/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class BeanProcessor {
    protected static final int PROPERTY_NOT_FOUND = -1;
    private static final Map<Class<?>, Object> primitiveDefaults = new HashMap();
    private final Map<String, String> columnToPropertyOverrides;

    public BeanProcessor() {
        this(new HashMap<String, String>());
    }

    public BeanProcessor(Map<String, String> columnToPropertyOverrides) {
        if (columnToPropertyOverrides == null) {
            throw new IllegalArgumentException("columnToPropertyOverrides map cannot be null");
        }
        this.columnToPropertyOverrides = columnToPropertyOverrides;
    }

    public <T> T toBean(ResultSet rs, Class<T> type) throws SQLException {
        PropertyDescriptor[] props2 = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props2);
        return this.createBean(rs, type, props2, columnToProperty);
    }

    public <T> List<T> toBeanList(ResultSet rs, Class<T> type) throws SQLException {
        ArrayList<T> results = new ArrayList<T>();
        if (!rs.next()) {
            return results;
        }
        PropertyDescriptor[] props2 = this.propertyDescriptors(type);
        ResultSetMetaData rsmd = rs.getMetaData();
        int[] columnToProperty = this.mapColumnsToProperties(rsmd, props2);
        do {
            results.add(this.createBean(rs, type, props2, columnToProperty));
        } while (rs.next());
        return results;
    }

    private <T> T createBean(ResultSet rs, Class<T> type, PropertyDescriptor[] props2, int[] columnToProperty) throws SQLException {
        T bean = this.newInstance(type);
        for (int i2 = 1; i2 < columnToProperty.length; ++i2) {
            if (columnToProperty[i2] == -1) continue;
            PropertyDescriptor prop = props2[columnToProperty[i2]];
            Class<?> propType = prop.getPropertyType();
            Object value = this.processColumn(rs, i2, propType);
            if (propType != null && value == null && propType.isPrimitive()) {
                value = primitiveDefaults.get(propType);
            }
            this.callSetter(bean, prop, value);
        }
        return bean;
    }

    private void callSetter(Object target, PropertyDescriptor prop, Object value) throws SQLException {
        Method setter = prop.getWriteMethod();
        if (setter == null) {
            return;
        }
        Class<?>[] params = setter.getParameterTypes();
        try {
            if (value instanceof java.util.Date) {
                String targetType = params[0].getName();
                if ("java.sql.Date".equals(targetType)) {
                    value = new Date(((java.util.Date)value).getTime());
                } else if ("java.sql.Time".equals(targetType)) {
                    value = new Time(((java.util.Date)value).getTime());
                } else if ("java.sql.Timestamp".equals(targetType)) {
                    value = new Timestamp(((java.util.Date)value).getTime());
                }
            }
            if (!this.isCompatibleType(value, params[0])) {
                throw new SQLException("Cannot set " + prop.getName() + ": incompatible types, cannot convert " + value.getClass().getName() + " to " + params[0].getName());
            }
            setter.invoke(target, value);
        }
        catch (IllegalArgumentException e2) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e2.getMessage());
        }
        catch (IllegalAccessException e3) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e3.getMessage());
        }
        catch (InvocationTargetException e4) {
            throw new SQLException("Cannot set " + prop.getName() + ": " + e4.getMessage());
        }
    }

    private boolean isCompatibleType(Object value, Class<?> type) {
        if (value == null || type.isInstance(value)) {
            return true;
        }
        if (type.equals(Integer.TYPE) && Integer.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Long.TYPE) && Long.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Double.TYPE) && Double.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Float.TYPE) && Float.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Short.TYPE) && Short.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Byte.TYPE) && Byte.class.isInstance(value)) {
            return true;
        }
        if (type.equals(Character.TYPE) && Character.class.isInstance(value)) {
            return true;
        }
        return type.equals(Boolean.TYPE) && Boolean.class.isInstance(value);
    }

    protected <T> T newInstance(Class<T> c2) throws SQLException {
        try {
            return c2.newInstance();
        }
        catch (InstantiationException e2) {
            throw new SQLException("Cannot create " + c2.getName() + ": " + e2.getMessage());
        }
        catch (IllegalAccessException e3) {
            throw new SQLException("Cannot create " + c2.getName() + ": " + e3.getMessage());
        }
    }

    private PropertyDescriptor[] propertyDescriptors(Class<?> c2) throws SQLException {
        BeanInfo beanInfo = null;
        try {
            beanInfo = Introspector.getBeanInfo(c2);
        }
        catch (IntrospectionException e2) {
            throw new SQLException("Bean introspection failed: " + e2.getMessage());
        }
        return beanInfo.getPropertyDescriptors();
    }

    protected int[] mapColumnsToProperties(ResultSetMetaData rsmd, PropertyDescriptor[] props2) throws SQLException {
        int cols = rsmd.getColumnCount();
        int[] columnToProperty = new int[cols + 1];
        Arrays.fill(columnToProperty, -1);
        block0: for (int col = 1; col <= cols; ++col) {
            String propertyName;
            String columnName = rsmd.getColumnLabel(col);
            if (null == columnName || 0 == columnName.length()) {
                columnName = rsmd.getColumnName(col);
            }
            if ((propertyName = this.columnToPropertyOverrides.get(columnName)) == null) {
                propertyName = columnName;
            }
            for (int i2 = 0; i2 < props2.length; ++i2) {
                if (!propertyName.equalsIgnoreCase(props2[i2].getName())) continue;
                columnToProperty[col] = i2;
                continue block0;
            }
        }
        return columnToProperty;
    }

    protected Object processColumn(ResultSet rs, int index, Class<?> propType) throws SQLException {
        if (!propType.isPrimitive() && rs.getObject(index) == null) {
            return null;
        }
        if (propType.equals(String.class)) {
            return rs.getString(index);
        }
        if (propType.equals(Integer.TYPE) || propType.equals(Integer.class)) {
            return rs.getInt(index);
        }
        if (propType.equals(Boolean.TYPE) || propType.equals(Boolean.class)) {
            return rs.getBoolean(index);
        }
        if (propType.equals(Long.TYPE) || propType.equals(Long.class)) {
            return rs.getLong(index);
        }
        if (propType.equals(Double.TYPE) || propType.equals(Double.class)) {
            return rs.getDouble(index);
        }
        if (propType.equals(Float.TYPE) || propType.equals(Float.class)) {
            return Float.valueOf(rs.getFloat(index));
        }
        if (propType.equals(Short.TYPE) || propType.equals(Short.class)) {
            return rs.getShort(index);
        }
        if (propType.equals(Byte.TYPE) || propType.equals(Byte.class)) {
            return rs.getByte(index);
        }
        if (propType.equals(Timestamp.class)) {
            return rs.getTimestamp(index);
        }
        if (propType.equals(SQLXML.class)) {
            return rs.getSQLXML(index);
        }
        return rs.getObject(index);
    }

    static {
        primitiveDefaults.put(Integer.TYPE, 0);
        primitiveDefaults.put(Short.TYPE, (short)0);
        primitiveDefaults.put(Byte.TYPE, (byte)0);
        primitiveDefaults.put(Float.TYPE, Float.valueOf(0.0f));
        primitiveDefaults.put(Double.TYPE, 0.0);
        primitiveDefaults.put(Long.TYPE, 0L);
        primitiveDefaults.put(Boolean.TYPE, Boolean.FALSE);
        primitiveDefaults.put(Character.TYPE, Character.valueOf('\u0000'));
    }
}

