/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbutils;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.dbutils.AbstractQueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;

public class QueryRunner
extends AbstractQueryRunner {
    public QueryRunner() {
    }

    public QueryRunner(boolean pmdKnownBroken) {
        super(pmdKnownBroken);
    }

    public QueryRunner(DataSource ds) {
        super(ds);
    }

    public QueryRunner(DataSource ds, boolean pmdKnownBroken) {
        super(ds, pmdKnownBroken);
    }

    public int[] batch(Connection conn, String sql, Object[][] params) throws SQLException {
        return this.batch(conn, false, sql, params);
    }

    public int[] batch(String sql, Object[][] params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.batch(conn, true, sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] batch(Connection conn, boolean closeConn, String sql, Object[][] params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        if (params == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null parameters. If parameters aren't need, pass an empty array.");
        }
        PreparedStatement stmt = null;
        int[] rows = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            for (int i2 = 0; i2 < params.length; ++i2) {
                this.fillStatement(stmt, params[i2]);
                stmt.addBatch();
            }
            rows = stmt.executeBatch();
        }
        catch (SQLException e2) {
            this.rethrow(e2, sql, (Object[])params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, false, sql, rsh, param);
    }

    @Deprecated
    public <T> T query(Connection conn, String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, false, sql, rsh, params);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        return this.query(conn, false, sql, rsh, params);
    }

    public <T> T query(Connection conn, String sql, ResultSetHandler<T> rsh) throws SQLException {
        return this.query(conn, false, sql, rsh, (Object[])null);
    }

    @Deprecated
    public <T> T query(String sql, Object param, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, param);
    }

    @Deprecated
    public <T> T query(String sql, Object[] params, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, params);
    }

    public <T> T query(String sql, ResultSetHandler<T> rsh) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.query(conn, true, sql, rsh, (Object[])null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T query(Connection conn, boolean closeConn, String sql, ResultSetHandler<T> rsh, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (!closeConn) throw new SQLException("Null SQL statement");
            this.close(conn);
            throw new SQLException("Null SQL statement");
        }
        if (rsh == null) {
            if (!closeConn) throw new SQLException("Null ResultSetHandler");
            this.close(conn);
            throw new SQLException("Null ResultSetHandler");
        }
        PreparedStatement stmt = null;
        ResultSet rs = null;
        T result = null;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rs = this.wrap(stmt.executeQuery());
            result = rsh.handle(rs);
            try {
                this.close(rs);
                return result;
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
        catch (SQLException e2) {
            this.rethrow(e2, sql, params);
            return result;
        }
        finally {
            try {
                this.close(rs);
            }
            finally {
                this.close(stmt);
                if (closeConn) {
                    this.close(conn);
                }
            }
        }
    }

    public int update(Connection conn, String sql) throws SQLException {
        return this.update(conn, false, sql, (Object[])null);
    }

    public int update(Connection conn, String sql, Object param) throws SQLException {
        return this.update(conn, false, sql, param);
    }

    public int update(Connection conn, String sql, Object ... params) throws SQLException {
        return this.update(conn, false, sql, params);
    }

    public int update(String sql) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, (Object[])null);
    }

    public int update(String sql, Object param) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, param);
    }

    public int update(String sql, Object ... params) throws SQLException {
        Connection conn = this.prepareConnection();
        return this.update(conn, true, sql, params);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int update(Connection conn, boolean closeConn, String sql, Object ... params) throws SQLException {
        if (conn == null) {
            throw new SQLException("Null connection");
        }
        if (sql == null) {
            if (closeConn) {
                this.close(conn);
            }
            throw new SQLException("Null SQL statement");
        }
        PreparedStatement stmt = null;
        int rows = 0;
        try {
            stmt = this.prepareStatement(conn, sql);
            this.fillStatement(stmt, params);
            rows = stmt.executeUpdate();
        }
        catch (SQLException e2) {
            this.rethrow(e2, sql, params);
        }
        finally {
            this.close(stmt);
            if (closeConn) {
                this.close(conn);
            }
        }
        return rows;
    }
}

