/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.BeetlTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.service.UserConfigStore;
import com.zaxxer.hikari.HikariDataSource;
import javax.sql.DataSource;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;

@Configuration
public class ApplicationConfigure {
    @Bean
    public ProjectPathResolver projectPathResolver(GeneratorConfig config) {
        return new ProjectPathResolver(config.getBasePackage());
    }

    @Bean
    public DataSource dataSource(GeneratorConfig config) {
        if (StrUtil.isBlank((CharSequence)config.getJdbcUrl())) {
            throw new IllegalArgumentException("\u5fc5\u987b\u6307\u5b9ajdbcUrl\u7528\u4e8e\u521b\u5efa\u6570\u636e\u6e90");
        }
        HikariDataSource ds = new HikariDataSource();
        ds.setJdbcUrl(config.getJdbcUrl());
        ds.setUsername(config.getUserName());
        ds.setPassword(config.getPassword());
        ds.setDriverClassName(config.getDriverClassName());
        return ds;
    }

    @Bean
    public DataSourceConfig dataSourceConfig(GeneratorConfig config) {
        DataSourceConfig dataSourceConfig = new DataSourceConfig();
        dataSourceConfig.setUrl(config.getJdbcUrl());
        dataSourceConfig.setDriverName(config.getDriverClassName());
        dataSourceConfig.setUsername(config.getUserName());
        dataSourceConfig.setPassword(config.getPassword());
        dataSourceConfig.setSchemaName(config.getSchemaName());
        return dataSourceConfig;
    }

    @Bean
    public JdbcTemplate dbcTemplate(DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Bean
    public BeetlTemplateEngine beetlTemplateEngine(UserConfigStore userConfigStore) {
        return new BeetlTemplateEngine(userConfigStore.getTemplateStoreDir());
    }
}

