/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui;

import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringBootConfiguration;
import org.springframework.boot.autoconfigure.http.HttpMessageConvertersAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.DispatcherServletAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.HttpEncodingAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.MultipartAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.ServletWebServerFactoryAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.autoconfigure.web.servlet.error.ErrorMvcAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.server.WebServerFactoryCustomizer;
import org.springframework.boot.web.servlet.server.ConfigurableServletWebServerFactory;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Import;

@SpringBootConfiguration
@Import(value={DispatcherServletAutoConfiguration.class, ServletWebServerFactoryAutoConfiguration.class, HttpEncodingAutoConfiguration.class, HttpMessageConvertersAutoConfiguration.class, MultipartAutoConfiguration.class, ErrorMvcAutoConfiguration.class, WebMvcAutoConfiguration.class})
@ComponentScan(value={"com.github.davidfantasy.mybatisplus.generatorui"})
public class MybatisPlusToolsApplication {
    private static final Logger log = LoggerFactory.getLogger(MybatisPlusToolsApplication.class);
    private static GeneratorConfig generatorConfig;

    public static void run(GeneratorConfig generatorConfig) {
        if (Strings.isNullOrEmpty((String)generatorConfig.getJdbcUrl())) {
            throw new IllegalArgumentException("jdbcUrl\u5fc5\u987b\u8981\u8bbe\u7f6e");
        }
        MybatisPlusToolsApplication.generatorConfig = generatorConfig;
        HashMap props = Maps.newHashMap();
        props.put("spring.resources.static-locations", "classpath:/generator-ui/");
        new SpringApplicationBuilder(new Class[0]).properties((Map)props).sources(new Class[]{MybatisPlusToolsApplication.class}).run(new String[0]);
    }

    @Bean
    public WebServerFactoryCustomizer<ConfigurableServletWebServerFactory> containerConfig(GeneratorConfig config) {
        return factory -> {
            if (config.getPort() != null) {
                factory.setPort(generatorConfig.getPort().intValue());
            } else {
                factory.setPort(8080);
            }
        };
    }

    @Bean
    public GeneratorConfig generatorConfig() {
        return generatorConfig;
    }
}

