/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui;

import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.google.common.base.Strings;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProjectPathResolver {
    private static final Logger log = LoggerFactory.getLogger(ProjectPathResolver.class);
    private String sourcePath;
    private String resourcePath;
    private String baseProjectPath;
    private String basePackage;
    private Pattern packagePattern = Pattern.compile("[a-zA-Z]+[0-9a-zA-Z_]*(\\.[a-zA-Z]+[0-9a-zA-Z_]*)*");

    public ProjectPathResolver(String basePackage) {
        this.basePackage = basePackage;
        String curentThreadPath = Thread.currentThread().getContextClassLoader().getResource(".").getPath();
        curentThreadPath = this.getUTF8String(curentThreadPath);
        String[] paths = curentThreadPath.split("/");
        StringBuilder temp = new StringBuilder();
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (i >= paths.length - 2) continue;
            temp.append(path);
            temp.append("/");
        }
        this.baseProjectPath = temp.toString();
        this.sourcePath = new File(this.baseProjectPath + "src/main/java").toString();
        this.resourcePath = new File(this.baseProjectPath + "src/main/resources").toString();
    }

    private String getUTF8String(String basePath) {
        try {
            basePath = URLDecoder.decode(basePath, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return basePath;
    }

    public String convertPackageToPath(String packageName) {
        if (Strings.isNullOrEmpty((String)packageName)) {
            throw new ServiceException("\u5305\u540d\u4e3a\u7a7a");
        }
        boolean isResourceFile = false;
        if (packageName.startsWith("resources:")) {
            packageName = packageName.replaceFirst("resources:", "");
            isResourceFile = true;
        }
        if (!this.packagePattern.matcher(packageName).matches()) {
            throw new ServiceException("\u4e0d\u662f\u5408\u6cd5\u7684\u5305\u540d\uff1a" + packageName);
        }
        String[] folders = packageName.split("\\.");
        String path = this.sourcePath;
        if (isResourceFile) {
            path = this.resourcePath;
        }
        for (String folder : folders) {
            path = path + File.separator + folder;
        }
        return path;
    }

    public String resolveEntityPackage() {
        return PathUtil.joinPackage(this.basePackage, "entity");
    }

    public String resolveControllerPackage() {
        return PathUtil.joinPackage(this.basePackage, "controller");
    }

    public String resolveServicePackage() {
        return PathUtil.joinPackage(this.basePackage, "service");
    }

    public String resolveServiceImplPackage() {
        return PathUtil.joinPackage(this.basePackage, "service", "impl");
    }

    public String resolveMapperPackage() {
        return PathUtil.joinPackage(this.basePackage, "mapper");
    }

    public String resolveMapperXmlPackage() {
        return "resources:mapper";
    }

    public String getSourcePath() {
        return this.sourcePath;
    }

    public String getResourcePath() {
        return this.resourcePath;
    }

    public String getBaseProjectPath() {
        return this.baseProjectPath;
    }

    public String getBasePackage() {
        return this.basePackage;
    }

    public Pattern getPackagePattern() {
        return this.packagePattern;
    }
}

