/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.mbp;

import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import org.beetl.core.Configuration;
import org.beetl.core.GroupTemplate;
import org.beetl.core.ResourceLoader;
import org.beetl.core.Template;
import org.beetl.core.resource.ClasspathResourceLoader;
import org.beetl.core.resource.CompositeResourceLoader;
import org.beetl.core.resource.FileResourceLoader;
import org.beetl.core.resource.Matcher;
import org.beetl.core.resource.StartsWithMatcher;

public class BeetlTemplateEngine
extends AbstractTemplateEngine {
    private GroupTemplate groupTemplate;
    private String templateStoreDir;

    public BeetlTemplateEngine(String templateStoreDir) {
        this.templateStoreDir = templateStoreDir;
        try {
            logger.info("\u6a21\u677f\u6839\u76ee\u5f55\u4e3a\uff1a" + templateStoreDir);
            ClasspathResourceLoader classpathResourceLoader = new ClasspathResourceLoader();
            FileResourceLoader fileResourceLoader = new FileResourceLoader(templateStoreDir);
            CompositeResourceLoader loader = new CompositeResourceLoader();
            loader.addResourceLoader((Matcher)new StartsWithMatcher("classpath:").withoutPrefix(), (ResourceLoader)classpathResourceLoader);
            loader.addResourceLoader((Matcher)new StartsWithMatcher("file:").withoutPrefix(), (ResourceLoader)fileResourceLoader);
            Configuration cfg = Configuration.defaultConfiguration();
            this.groupTemplate = new GroupTemplate((ResourceLoader)loader, cfg);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    public void writer(Map<String, Object> objectMap, String templatePath, String outputFile) throws Exception {
        if (templatePath.startsWith("file:")) {
            templatePath = templatePath.replace(this.templateStoreDir, "");
        }
        logger.info("templatePath:" + templatePath);
        Template template = this.groupTemplate.getTemplate(templatePath);
        try (FileOutputStream fileOutputStream = new FileOutputStream(outputFile);){
            template.binding(objectMap);
            template.renderTo((OutputStream)fileOutputStream);
        }
        logger.info("\u5df2\u751f\u6210\u6587\u4ef6:" + outputFile);
    }

    public String templateFilePath(String filePath) {
        return filePath;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String write2String(Map<String, Object> objectMap, String templatePath) {
        if (templatePath.startsWith("file:")) {
            templatePath = templatePath.replace(this.templateStoreDir, "");
        }
        Template template = this.groupTemplate.getTemplate(templatePath);
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            template.binding(objectMap);
            template.renderTo((OutputStream)baos);
            String string = baos.toString("utf-8");
            return string;
        }
        catch (IOException e) {
            e.printStackTrace();
            return "";
        }
    }
}

