/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.mbp;

import cn.hutool.core.util.StrUtil;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.NameConverter;
import com.google.common.base.Strings;

public class DefaultNameConverter
implements NameConverter {
    @Override
    public String entityNameConvert(String tableName) {
        if (Strings.isNullOrEmpty((String)tableName)) {
            return "";
        }
        tableName = tableName.substring(tableName.indexOf("_") + 1, tableName.length());
        return StrUtil.upperFirst((CharSequence)StrUtil.toCamelCase((CharSequence)tableName));
    }

    @Override
    public String propertyNameConvert(String fieldName) {
        if (Strings.isNullOrEmpty((String)fieldName)) {
            return "";
        }
        return StrUtil.toCamelCase((CharSequence)fieldName.toLowerCase());
    }

    @Override
    public String outputFileNameConvert(String fileType, String entityName) {
        if (fileType.equals("Entity")) {
            return entityName + ".java";
        }
        if (fileType.equals("Mapper.java")) {
            return entityName + "Mapper" + ".java";
        }
        if (fileType.equals("Mapper.xml")) {
            return entityName + "Mapper" + ".xml";
        }
        if (fileType.equals("Service")) {
            return "I" + entityName + "Service" + ".java";
        }
        if (fileType.equals("ServiceImpl")) {
            return entityName + "ServiceImpl" + ".java";
        }
        if (fileType.equals("Controller")) {
            return entityName + "Controller" + ".java";
        }
        return entityName + fileType;
    }
}

