/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import com.baomidou.mybatisplus.annotation.DbType;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.IDbQuery;
import com.github.davidfantasy.mybatisplus.generatorui.dto.TableInfo;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class DatabaseService {
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private DataSourceConfig dataSourceConfig;

    public List<TableInfo> getTablesFromDb() {
        IDbQuery dbQuery = this.dataSourceConfig.getDbQuery();
        List results = this.jdbcTemplate.queryForList(this.getTableSql());
        ArrayList tableInfos = Lists.newArrayList();
        for (Map table : results) {
            TableInfo tableInfo = new TableInfo();
            tableInfo.setName((String)table.get(dbQuery.tableName()));
            tableInfo.setComment((String)table.get(dbQuery.tableComment()));
            tableInfos.add(tableInfo);
        }
        return tableInfos;
    }

    public String getTableSql() {
        String tablesSql = this.dataSourceConfig.getDbQuery().tablesSql();
        if (DbType.POSTGRE_SQL == this.dataSourceConfig.getDbType()) {
            String schema = this.dataSourceConfig.getSchemaName();
            if (schema == null) {
                schema = "public";
                this.dataSourceConfig.setSchemaName(schema);
            }
            tablesSql = String.format(tablesSql, schema);
        } else if (DbType.KINGBASE_ES == this.dataSourceConfig.getDbType()) {
            String schema = this.dataSourceConfig.getSchemaName();
            if (schema == null) {
                schema = "PUBLIC";
                this.dataSourceConfig.setSchemaName(schema);
            }
            tablesSql = String.format(tablesSql, schema);
        } else if (DbType.DB2 == this.dataSourceConfig.getDbType()) {
            String schema = this.dataSourceConfig.getSchemaName();
            if (schema == null) {
                schema = "current schema";
                this.dataSourceConfig.setSchemaName(schema);
            }
            tablesSql = String.format(tablesSql, schema);
        } else if (DbType.ORACLE == this.dataSourceConfig.getDbType()) {
            String schema = this.dataSourceConfig.getSchemaName();
            if (schema == null) {
                schema = this.dataSourceConfig.getUsername().toUpperCase();
                this.dataSourceConfig.setSchemaName(schema);
            }
            tablesSql = String.format(tablesSql, schema);
        }
        return tablesSql;
    }
}

