/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import com.baomidou.mybatisplus.generator.AutoGenerator;
import com.baomidou.mybatisplus.generator.InjectionConfig;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.FileOutConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.INameConvert;
import com.baomidou.mybatisplus.generator.config.PackageConfig;
import com.baomidou.mybatisplus.generator.config.StrategyConfig;
import com.baomidou.mybatisplus.generator.config.TemplateConfig;
import com.baomidou.mybatisplus.generator.config.po.TableField;
import com.baomidou.mybatisplus.generator.config.po.TableInfo;
import com.baomidou.mybatisplus.generator.engine.AbstractTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.dto.GenSetting;
import com.github.davidfantasy.mybatisplus.generatorui.dto.OutputFileInfo;
import com.github.davidfantasy.mybatisplus.generatorui.dto.UserConfig;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.BeetlTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.NameConverter;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.TableInjectionConfig;
import com.github.davidfantasy.mybatisplus.generatorui.service.UserConfigStore;
import com.github.davidfantasy.mybatisplus.generatorui.strategy.EntityStrategy;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MbpGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(MbpGeneratorService.class);
    private AutoGenerator mpg;
    @Autowired
    private DataSourceConfig ds;
    @Autowired
    private GeneratorConfig generatorConfig;
    @Autowired
    private UserConfigStore userConfigStore;
    @Autowired
    private ProjectPathResolver projectPathResolver;
    @Autowired
    private BeetlTemplateEngine beetlTemplateEngine;

    @PostConstruct
    public void initGenerator() {
        this.mpg = new AutoGenerator();
        this.mpg.setDataSource(this.ds);
        TemplateConfig templateConfig = new TemplateConfig();
        templateConfig.setController(null);
        templateConfig.setEntity(null);
        templateConfig.setEntityKt(null);
        templateConfig.setMapper(null);
        templateConfig.setServiceImpl(null);
        templateConfig.setService(null);
        templateConfig.setXml(null);
        this.mpg.setTemplate(templateConfig);
        GlobalConfig gc = new GlobalConfig();
        gc.setOpen(false);
        gc.setDateType(this.generatorConfig.getDateType());
        this.mpg.setGlobalConfig(gc);
        this.mpg.setTemplateEngine((AbstractTemplateEngine)this.beetlTemplateEngine);
    }

    public void genCodeBatch(GenSetting genSetting, List<String> tables) {
        this.mpg.setCfg((InjectionConfig)new TableInjectionConfig(this.generatorConfig));
        UserConfig userConfig = this.userConfigStore.getDefaultUserConfig();
        BeanUtils.copyProperties((Object)userConfig.getEntityStrategy(), (Object)this.mpg.getGlobalConfig());
        this.mpg.getGlobalConfig().setAuthor(genSetting.getAuthor());
        this.mpg.getGlobalConfig().setFileOverride(genSetting.isOverride());
        StrategyConfig strategy = this.getCurrentStrategy(userConfig);
        final NameConverter nameConverter = this.generatorConfig.getAvailableNameConverter();
        strategy.setNameConvert(new INameConvert(){

            public String entityNameConvert(TableInfo tableInfo) {
                return nameConverter.entityNameConvert(tableInfo.getName());
            }

            public String propertyNameConvert(TableField field) {
                return nameConverter.propertyNameConvert(field.getName());
            }
        });
        this.mpg.setStrategy(strategy);
        PackageConfig pc = new PackageConfig();
        pc.setParent(null);
        pc.setController(PathUtil.joinPackage(userConfig.getControllerInfo().getOutputLocation(), genSetting.getModuleName()));
        pc.setEntity(PathUtil.joinPackage(userConfig.getEntityInfo().getOutputLocation(), genSetting.getModuleName()));
        pc.setMapper(PathUtil.joinPackage(userConfig.getMapperInfo().getOutputLocation(), genSetting.getModuleName()));
        pc.setService(PathUtil.joinPackage(userConfig.getServiceInfo().getOutputLocation(), genSetting.getModuleName()));
        pc.setServiceImpl(PathUtil.joinPackage(userConfig.getServiceImplInfo().getOutputLocation(), genSetting.getModuleName()));
        this.mpg.setPackageInfo(pc);
        for (String table : tables) {
            this.genCode(this.mpg, genSetting, userConfig, table);
        }
    }

    private void genCode(AutoGenerator ag, GenSetting genSetting, UserConfig userConfig, String tableName) {
        ArrayList<2> focList = new ArrayList<2>();
        for (OutputFileInfo outputFileInfo : userConfig.getOutputFiles()) {
            if (!genSetting.getChoosedOutputFiles().contains(outputFileInfo.getFileType())) continue;
            NameConverter nameConverter = this.generatorConfig.getAvailableNameConverter();
            String fileName = nameConverter.outputFileNameConvert(outputFileInfo.getFileType(), nameConverter.entityNameConvert(tableName));
            String outputDir = this.projectPathResolver.convertPackageToPath(outputFileInfo.getOutputLocation());
            final String filePath = PathUtil.joinPath(outputDir, genSetting.getModuleName(), fileName);
            focList.add(new FileOutConfig(outputFileInfo.getAvailableTemplatePath()){

                public String outputFile(TableInfo tableInfo) {
                    return filePath;
                }
            });
        }
        ag.getStrategy().setInclude(new String[]{tableName});
        ag.getCfg().setFileOutConfigList(focList);
        ag.setConfig(null);
        ag.execute();
    }

    private StrategyConfig getCurrentStrategy(UserConfig userConfig) {
        StrategyConfig strategy = new StrategyConfig();
        EntityStrategy entityStrategy = userConfig.getEntityStrategy();
        if (!Strings.isNullOrEmpty((String)entityStrategy.getSuperEntityClass())) {
            strategy.setSuperEntityClass(entityStrategy.getSuperEntityClass());
        }
        BeanUtils.copyProperties((Object)userConfig.getControllerStrategy(), (Object)strategy);
        BeanUtils.copyProperties((Object)entityStrategy, (Object)strategy, (String[])new String[]{"superEntityClass"});
        BeanUtils.copyProperties((Object)userConfig.getMapperStrategy(), (Object)strategy);
        BeanUtils.copyProperties((Object)userConfig.getMapperXmlStrategy(), (Object)strategy);
        BeanUtils.copyProperties((Object)userConfig.getServiceImplStrategy(), (Object)strategy);
        BeanUtils.copyProperties((Object)userConfig.getServiceStrategy(), (Object)strategy);
        return strategy;
    }
}

