/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import cn.hutool.core.date.DateUtil;
import com.baomidou.mybatisplus.generator.config.DataSourceConfig;
import com.baomidou.mybatisplus.generator.config.GlobalConfig;
import com.baomidou.mybatisplus.generator.config.rules.IColumnType;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.ProjectPathResolver;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.ElementPosition;
import com.github.davidfantasy.mybatisplus.generatorui.dto.GenDtoConfig;
import com.github.davidfantasy.mybatisplus.generatorui.dto.GenDtoFromSqlReq;
import com.github.davidfantasy.mybatisplus.generatorui.dto.MapperElement;
import com.github.davidfantasy.mybatisplus.generatorui.dto.SelectResultField;
import com.github.davidfantasy.mybatisplus.generatorui.mbp.BeetlTemplateEngine;
import com.github.davidfantasy.mybatisplus.generatorui.service.MapperXmlParser;
import com.github.davidfantasy.mybatisplus.generatorui.util.SqlFormatUtils;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Date;
import java.util.HashMap;
import org.dom4j.DocumentException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.support.rowset.SqlRowSet;
import org.springframework.jdbc.support.rowset.SqlRowSetMetaData;
import org.springframework.stereotype.Service;

@Service
public class SqlGeneratorService {
    private static final Logger log = LoggerFactory.getLogger(SqlGeneratorService.class);
    final Base64.Decoder decoder = Base64.getDecoder();
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    private GeneratorConfig generatorConfig;
    @Autowired
    private BeetlTemplateEngine beetlTemplateEngine;
    @Autowired
    private ProjectPathResolver projectPathResolver;
    @Autowired
    private DataSourceConfig dataSourceConfig;
    @Autowired
    private MapperXmlParser mapperXmlParser;

    public void genMapperMethod(GenDtoFromSqlReq params) throws Exception {
        boolean genDto;
        if (Strings.isNullOrEmpty((String)params.getSql())) {
            throw new ServiceException("\u6570\u636e\u6e90SQL\u4e0d\u80fd\u4e3a\u7a7a");
        }
        String decodedSql = new String(this.decoder.decode(params.getSql()), "UTF-8");
        if (!decodedSql.trim().toLowerCase().startsWith("select")) {
            throw new ServiceException("\u53ea\u80fd\u901a\u8fc7\u67e5\u8be2\u8bed\u53e5\u751f\u6210DTO\u5bf9\u8c61\uff0c\u8bf7\u68c0\u67e5SQL");
        }
        boolean bl = genDto = !Strings.isNullOrEmpty((String)params.getConfig().getFullPackage());
        if (genDto) {
            this.genDtoFileFromSQL(decodedSql, params.getConfig());
        }
        this.genMapperElementsFromSql(decodedSql, params.getConfig(), genDto);
    }

    public void genDtoFileFromSQL(String sql, GenDtoConfig config) throws Exception {
        SqlRowSet rowSet = null;
        try {
            rowSet = this.jdbcTemplate.queryForRowSet(sql);
        }
        catch (Exception e) {
            log.error("\u6267\u884cSQL\u53d1\u751f\u9519\u8bef", (Throwable)e);
            throw new ServiceException("\u6267\u884cSQL\u53d1\u751f\u9519\u8bef\uff1a" + e.getMessage());
        }
        SqlRowSetMetaData metaData = rowSet.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList fields = Lists.newArrayList();
        GlobalConfig mbpConfig = new GlobalConfig();
        mbpConfig.setDateType(this.generatorConfig.getDateType());
        for (int i = 1; i <= columnCount; ++i) {
            SelectResultField resultField = new SelectResultField();
            resultField.setColumnName(metaData.getColumnLabel(i));
            String colType = metaData.getColumnTypeName(i);
            IColumnType columnType = this.dataSourceConfig.getTypeConvert().processTypeConvert(mbpConfig, metaData.getColumnTypeName(i));
            resultField.setJavaType(columnType.getType());
            config.addImportPackage(columnType.getPkg());
            resultField.setPropertyName(this.generatorConfig.getAvailableNameConverter().propertyNameConvert(resultField.getColumnName()));
            fields.add(resultField);
        }
        config.setFields(fields);
        config.setCreateDate(DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd"));
        if (Strings.isNullOrEmpty((String)config.getMapperLocation())) {
            config.setComment(config.getMapperLocation() + "\u7684\u67e5\u8be2\u7ed3\u679c\u96c6\uff0c\u8be5\u4ee3\u7801\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210");
        } else {
            config.setComment("\u8be5\u4ee3\u7801\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210");
        }
        HashMap tplParams = Maps.newHashMap();
        tplParams.put("config", config);
        String outputPath = this.projectPathResolver.convertPackageToPath(config.getFullPackage()) + ".java";
        File file = new File(outputPath);
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        this.beetlTemplateEngine.writer(tplParams, "classpath:templates/dto.btl", outputPath);
        log.info("DTO\u5df2\u6210\u529f\u751f\u6210\uff0c\u8f93\u51fa\u4f4d\u7f6e\u4e3a:" + outputPath);
    }

    public void genMapperElementsFromSql(String sql, GenDtoConfig config, boolean genResultMap) throws IOException, DocumentException {
        ArrayList elements = Lists.newArrayList();
        if (genResultMap) {
            elements.add(this.createResultMapElement(config));
        }
        elements.add(this.createMapperMethodElement(sql, config));
        String mapperPath = this.projectPathResolver.convertPackageToPath(config.getMapperPackage()) + ".xml";
        this.mapperXmlParser.addElementInMapper(mapperPath, elements.toArray(new MapperElement[0]));
        log.info("ResultMap\u548cMapper\u65b9\u6cd5\u5df2\u751f\u6210\uff0c\u8f93\u51fa\u4f4d\u7f6e\u4e3a:" + mapperPath);
    }

    public MapperElement createResultMapElement(GenDtoConfig config) {
        HashMap tplParams = Maps.newHashMap();
        tplParams.put("config", config);
        String resultMapStr = this.beetlTemplateEngine.write2String(tplParams, "classpath:templates/resultMap.btl");
        MapperElement resultMapEle = MapperElement.builder().id(config.getDtoName() + "Map").comment("Author:" + config.getAuthor() + "\uff0cDate:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + "\uff0c" + config.getMapperElementId() + "\u7684\u7ed3\u679c\u6620\u5c04\u914d\u7f6e\uff0c\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210").content(resultMapStr).location(ElementPosition.FIRST).build();
        return resultMapEle;
    }

    public MapperElement createMapperMethodElement(String sql, GenDtoConfig config) {
        HashMap tplParams = Maps.newHashMap();
        String dbType = this.dataSourceConfig.getDbType().getDb();
        tplParams.put("config", config);
        tplParams.put("elementType", "select");
        tplParams.put("sql", SqlFormatUtils.format(sql, dbType));
        String methodEleStr = this.beetlTemplateEngine.write2String(tplParams, "classpath:templates/mapperMethods.btl");
        MapperElement methodEle = MapperElement.builder().id(config.getMapperElementId()).comment("Author:" + config.getAuthor() + "\uff0cDate:" + DateUtil.format((Date)new Date(), (String)"yyyy-MM-dd") + ",\u7531mybatis-plus-generator-ui\u81ea\u52a8\u751f\u6210").content(methodEleStr).location(ElementPosition.LAST).build();
        return methodEle;
    }
}

