/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.service;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.io.FileUtil;
import com.github.davidfantasy.mybatisplus.generatorui.GeneratorConfig;
import com.github.davidfantasy.mybatisplus.generatorui.common.ServiceException;
import com.github.davidfantasy.mybatisplus.generatorui.dto.UserConfig;
import com.github.davidfantasy.mybatisplus.generatorui.service.OutputFileInfoService;
import com.github.davidfantasy.mybatisplus.generatorui.util.JsonUtil;
import com.github.davidfantasy.mybatisplus.generatorui.util.PathUtil;
import com.google.common.io.Files;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.Date;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Component
public class UserConfigStore {
    private static final Logger log = LoggerFactory.getLogger(UserConfigStore.class);
    private String storeDir;
    private String userConfigPath;
    @Autowired
    private OutputFileInfoService outputFileInfoService;
    @Autowired
    private GeneratorConfig generatorConfig;

    @PostConstruct
    public void init() {
        this.storeDir = PathUtil.joinPath(System.getProperty("user.home"), ".mybatis-plus-generator-ui", this.generatorConfig.getBasePackage());
        this.userConfigPath = this.storeDir + File.separator + "user-config.json";
    }

    public String getTemplateStoreDir() {
        return PathUtil.joinPath(this.storeDir, "template");
    }

    public UserConfig getDefaultUserConfig() {
        UserConfig userConfig = this.getUserConfigFromFile();
        if (userConfig == null) {
            userConfig = new UserConfig();
            userConfig.setOutputFiles(this.outputFileInfoService.getBuiltInFileInfo());
        }
        return userConfig;
    }

    public UserConfig getUserConfigFromFile() {
        if (!FileUtil.exist((String)this.userConfigPath)) {
            return null;
        }
        String userConfigStr = FileUtil.readString((String)this.userConfigPath, (Charset)Charset.forName("utf-8"));
        try {
            return JsonUtil.json2obj(userConfigStr, UserConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u8bfb\u53d6\u7528\u6237\u914d\u7f6e\u6587\u4ef6\u53d1\u751f\u9519\u8bef\uff1a{}", (Object)e.getMessage());
            return null;
        }
    }

    public void saveUserConfig(UserConfig userConfig) throws IOException {
        if (userConfig == null) {
            throw new ServiceException("\u4e0d\u80fd\u5199\u5165\u7a7a\u7684\u7528\u6237\u914d\u7f6e");
        }
        String configStr = JsonUtil.obj2json(userConfig);
        File userConfigFile = new File(this.userConfigPath);
        if (userConfigFile.exists()) {
            userConfigFile.delete();
        }
        Files.createParentDirs((File)userConfigFile);
        userConfigFile.createNewFile();
        FileUtil.writeFromStream((InputStream)new ByteArrayInputStream(configStr.getBytes(Charset.forName("utf-8"))), (File)userConfigFile);
    }

    public String uploadTemplate(MultipartFile file) {
        String fileName = file.getOriginalFilename();
        String fileSuffix = fileName.substring(file.getOriginalFilename().lastIndexOf(".") + 1);
        String saveFileName = fileName.substring(0, fileName.lastIndexOf(fileSuffix)) + DateUtil.format((Date)new Date(), (String)"yyyyMMddHHmmss");
        String savePath = PathUtil.joinPath(this.getTemplateStoreDir(), saveFileName);
        log.info("\u6a21\u677f\u4e0a\u4f20\u8def\u5f84\u4e3a\uff1a{}", (Object)savePath);
        File saveFile = new File(savePath);
        try {
            FileUtil.writeFromStream((InputStream)file.getInputStream(), (File)saveFile);
        }
        catch (IOException e) {
            throw new ServiceException("\u4e0a\u4f20\u6a21\u677f\u6587\u4ef6\u5931\u8d25", e);
        }
        return "file:" + savePath;
    }
}

