/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.mybatisplus.generatorui.util;

import com.alibaba.druid.DruidRuntimeException;
import com.alibaba.druid.sql.ast.SQLExpr;
import com.alibaba.druid.sql.ast.SQLObject;
import com.alibaba.druid.sql.ast.SQLStatement;
import com.alibaba.druid.sql.ast.expr.SQLBinaryOpExpr;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2OutputVisitor;
import com.alibaba.druid.sql.dialect.db2.visitor.DB2SchemaStatVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlOutputVisitor;
import com.alibaba.druid.sql.dialect.mysql.visitor.MySqlSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.odps.visitor.OdpsOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleOutputVisitor;
import com.alibaba.druid.sql.dialect.oracle.visitor.OracleSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGOutputVisitor;
import com.alibaba.druid.sql.dialect.postgresql.visitor.PGSchemaStatVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerOutputVisitor;
import com.alibaba.druid.sql.dialect.sqlserver.visitor.SQLServerSchemaStatVisitor;
import com.alibaba.druid.sql.parser.ParserException;
import com.alibaba.druid.sql.parser.SQLExprParser;
import com.alibaba.druid.sql.parser.SQLParserUtils;
import com.alibaba.druid.sql.parser.SQLStatementParser;
import com.alibaba.druid.sql.parser.Token;
import com.alibaba.druid.sql.visitor.SQLASTOutputVisitor;
import com.alibaba.druid.sql.visitor.SQLASTVisitor;
import com.alibaba.druid.sql.visitor.SchemaStatVisitor;
import com.alibaba.druid.support.logging.Log;
import com.alibaba.druid.support.logging.LogFactory;
import com.alibaba.druid.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

public class SqlFormatUtils {
    private static final Log LOG = LogFactory.getLog(SqlFormatUtils.class);

    public static String toSQLString(SQLObject sqlObject, String dbType) {
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return SqlFormatUtils.toMySqlString(sqlObject);
        }
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            return SqlFormatUtils.toOracleString(sqlObject);
        }
        if ("postgresql".equals(dbType)) {
            return SqlFormatUtils.toPGString(sqlObject);
        }
        if ("db2".equals(dbType)) {
            return SqlFormatUtils.toDB2String(sqlObject);
        }
        if ("odps".equals(dbType)) {
            return SqlFormatUtils.toDB2String(sqlObject);
        }
        return SqlFormatUtils.toSQLServerString(sqlObject);
    }

    public static String toSQLString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new SQLASTOutputVisitor((Appendable)out));
        String sql = out.toString();
        return sql;
    }

    public static String toOdpsString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new OdpsOutputVisitor((Appendable)out));
        String sql = out.toString();
        return sql;
    }

    public static String toMySqlString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new MySqlOutputVisitor((Appendable)out));
        String sql = out.toString();
        return sql;
    }

    public static SQLExpr toMySqlExpr(String sql) {
        return SqlFormatUtils.toSQLExpr(sql, "mysql");
    }

    public static String formatMySql(String sql) {
        return SqlFormatUtils.format(sql, "mysql");
    }

    public static String formatOracle(String sql) {
        return SqlFormatUtils.format(sql, "oracle");
    }

    public static String formatOdps(String sql) {
        return SqlFormatUtils.format(sql, "odps");
    }

    public static String toOracleString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new OracleOutputVisitor((Appendable)out, false));
        String sql = out.toString();
        return sql;
    }

    public static String toPGString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new PGOutputVisitor((Appendable)out));
        String sql = out.toString();
        return sql;
    }

    public static String toDB2String(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new DB2OutputVisitor((Appendable)out));
        String sql = out.toString();
        return sql;
    }

    public static String toSQLServerString(SQLObject sqlObject) {
        StringBuilder out = new StringBuilder();
        sqlObject.accept((SQLASTVisitor)new SQLServerOutputVisitor((Appendable)out));
        String sql = out.toString();
        return sql;
    }

    public static String formatPGSql(String sql) {
        return SqlFormatUtils.format(sql, "postgresql");
    }

    public static SQLExpr toSQLExpr(String sql, String dbType) {
        SQLExprParser parser = SQLParserUtils.createExprParser((String)sql, (String)dbType);
        SQLExpr expr = parser.expr();
        if (parser.getLexer().token() != Token.EOF) {
            throw new ParserException("illegal sql expr : " + sql);
        }
        return expr;
    }

    public static List<SQLStatement> toStatementList(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (String)dbType);
        return parser.parseStatementList();
    }

    public static SQLExpr toSQLExpr(String sql) {
        return SqlFormatUtils.toSQLExpr(sql, null);
    }

    public static String format(String sql, String dbType) {
        return SqlFormatUtils.format(sql, dbType, null);
    }

    public static String format(String sql, String dbType, List<Object> parameters) {
        try {
            List<SQLStatement> statementList = SqlFormatUtils.toStatementList(sql, dbType);
            return SqlFormatUtils.toSQLString(statementList, dbType, parameters);
        }
        catch (ParserException ex) {
            LOG.warn("format error", (Throwable)ex);
            return sql;
        }
    }

    public static String toSQLString(List<SQLStatement> statementList, String dbType) {
        return SqlFormatUtils.toSQLString(statementList, dbType, null);
    }

    public static String toSQLString(List<SQLStatement> statementList, String dbType, List<Object> parameters) {
        StringBuilder out = new StringBuilder();
        SQLASTOutputVisitor visitor = SqlFormatUtils.createFormatOutputVisitor(out, statementList, dbType);
        if (parameters != null) {
            visitor.setParameters(parameters);
        }
        for (SQLStatement stmt : statementList) {
            stmt.accept((SQLASTVisitor)visitor);
        }
        return out.toString();
    }

    public static SQLASTOutputVisitor createFormatOutputVisitor(Appendable out, List<SQLStatement> statementList, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            if (statementList.size() == 1) {
                return new OracleOutputVisitor(out, false);
            }
            return new OracleOutputVisitor(out, true);
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlOutputVisitor(out);
        }
        if ("postgresql".equals(dbType)) {
            return new PGOutputVisitor(out);
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerOutputVisitor(out);
        }
        if ("db2".equals(dbType)) {
            return new DB2OutputVisitor(out);
        }
        return new SQLASTOutputVisitor(out);
    }

    public static SchemaStatVisitor createSchemaStatVisitor(List<SQLStatement> statementList, String dbType) {
        if ("oracle".equals(dbType) || "AliOracle".equals(dbType)) {
            if (statementList.size() == 1) {
                return new OracleSchemaStatVisitor();
            }
            return new OracleSchemaStatVisitor();
        }
        if ("mysql".equals(dbType) || "mariadb".equals(dbType) || "h2".equals(dbType)) {
            return new MySqlSchemaStatVisitor();
        }
        if ("postgresql".equals(dbType)) {
            return new PGSchemaStatVisitor();
        }
        if ("sqlserver".equals(dbType) || "jtds".equals(dbType)) {
            return new SQLServerSchemaStatVisitor();
        }
        if ("db2".equals(dbType)) {
            return new DB2SchemaStatVisitor();
        }
        return new SchemaStatVisitor();
    }

    public static List<SQLStatement> parseStatements(String sql, String dbType) {
        SQLStatementParser parser = SQLParserUtils.createSQLStatementParser((String)sql, (String)dbType);
        List stmtList = parser.parseStatementList();
        if (parser.getLexer().token() != Token.EOF) {
            throw new DruidRuntimeException("syntax error : " + sql);
        }
        return stmtList;
    }

    public static String buildToDate(String columnName, String tableAlias, String pattern, String dbType) {
        StringBuilder sql = new StringBuilder();
        if (StringUtils.isEmpty((String)columnName)) {
            return "";
        }
        if (StringUtils.isEmpty((String)dbType)) {
            dbType = "mysql";
        }
        String formatMethod = "";
        if ("mysql".equalsIgnoreCase(dbType)) {
            formatMethod = "STR_TO_DATE";
            if (StringUtils.isEmpty((String)pattern)) {
                pattern = "%Y-%m-%d %H:%i:%s";
            }
        } else if ("oracle".equalsIgnoreCase(dbType)) {
            formatMethod = "TO_DATE";
            if (StringUtils.isEmpty((String)pattern)) {
                pattern = "yyyy-mm-dd hh24:mi:ss";
            }
        } else {
            return "";
        }
        sql.append(formatMethod).append("(");
        if (!StringUtils.isEmpty((String)tableAlias)) {
            sql.append(tableAlias).append(".");
        }
        sql.append(columnName).append(",");
        sql.append("'");
        sql.append(pattern);
        sql.append("')");
        return sql.toString();
    }

    public static List<SQLExpr> split(SQLBinaryOpExpr x) {
        ArrayList<SQLExpr> groupList = new ArrayList<SQLExpr>();
        groupList.add(x.getRight());
        SQLExpr left = x.getLeft();
        while (left instanceof SQLBinaryOpExpr && ((SQLBinaryOpExpr)left).getOperator() == x.getOperator()) {
            SQLBinaryOpExpr binaryLeft = (SQLBinaryOpExpr)left;
            groupList.add(binaryLeft.getRight());
            left = binaryLeft.getLeft();
        }
        groupList.add(left);
        return groupList;
    }
}

