/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.jwtshiro;

import com.github.davidfantasy.jwtshiro.PermUtil;
import com.github.davidfantasy.jwtshiro.annotation.AlowAnonymous;
import com.github.davidfantasy.jwtshiro.annotation.RequiresPerms;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shiro.web.filter.mgt.DefaultFilterChainManager;
import org.apache.shiro.web.filter.mgt.PathMatchingFilterChainResolver;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.mvc.method.RequestMappingInfo;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

public class AnnotationFilterRuleLoader {
    private static final Logger logger = LoggerFactory.getLogger(AnnotationFilterRuleLoader.class);
    private AbstractShiroFilter shiroFilter;
    private RequestMappingHandlerMapping handlerMapping;
    public static final String BASE_AUTH_PERM_NAME = "base-auth";
    private static final Pattern pathVarUrlPattern = Pattern.compile("\\{\\w+\\}");

    protected AnnotationFilterRuleLoader(AbstractShiroFilter shiroFilter, RequestMappingHandlerMapping handlerMapping) {
        this.shiroFilter = shiroFilter;
        this.handlerMapping = handlerMapping;
    }

    public void refreshRuleMapping() {
        Map infos = this.handlerMapping.getHandlerMethods();
        HashMap urlRules = Maps.newHashMap();
        for (Map.Entry entry : infos.entrySet()) {
            String methodPerm;
            Method urlMethod = ((HandlerMethod)entry.getValue()).getMethod();
            Class urlBeanClass = ((HandlerMethod)entry.getValue()).getBeanType();
            String url = ((RequestMappingInfo)entry.getKey()).getPatternsCondition().getPatterns().toString();
            url = url.substring(1, url.length() - 1);
            String beanPerm = this.parsePermFromClass(urlBeanClass);
            String perm = this.concatPerms(beanPerm, methodPerm = this.parsePermFromMethod(urlMethod));
            if (perm == null) continue;
            Matcher pathVarUrlMatcher = pathVarUrlPattern.matcher(url);
            if (pathVarUrlMatcher.find()) {
                url = pathVarUrlMatcher.replaceAll("**");
            }
            PermUtil.addUrlMapping(url, perm);
            if (urlRules.containsKey(url)) {
                logger.warn("{}\u94fe\u63a5\u6743\u9650\u91cd\u590d\u5b9a\u4e49\uff0c\u4ec5\u6700\u65b0\u7684\u6743\u9650\u8bbe\u7f6e\u6709\u6548:{}", (Object)url, urlRules.get(url));
            }
            if ("anon".equals(perm)) {
                urlRules.put(url, "anon");
                continue;
            }
            urlRules.put(url, "jwtAuthc,jwtPerm[" + perm + "]");
        }
        this.updateShiroPermissionDefines(urlRules);
    }

    private void updateShiroPermissionDefines(Map<String, String> urlRules) {
        PathMatchingFilterChainResolver filterChainResolver = (PathMatchingFilterChainResolver)this.shiroFilter.getFilterChainResolver();
        DefaultFilterChainManager manager = (DefaultFilterChainManager)filterChainResolver.getFilterChainManager();
        manager.getFilterChains().clear();
        logger.info("\u5f00\u59cb\u8bbe\u7f6eshiro\u7684\u94fe\u63a5\u6743\u9650...");
        for (Map.Entry<String, String> entry : urlRules.entrySet()) {
            logger.info(entry.toString());
            String url = entry.getKey();
            String chainDefinition = entry.getValue().trim().replace(" ", "");
            manager.createChain(url, chainDefinition);
        }
        manager.createChain("/**", "jwtAuthc");
    }

    private String parsePermFromClass(Class<?> beanClass) {
        RequiresPerms rp = beanClass.getAnnotation(RequiresPerms.class);
        AlowAnonymous anon = beanClass.getAnnotation(AlowAnonymous.class);
        if (rp != null && anon != null) {
            throw new IllegalStateException("\u4e0d\u80fd\u540c\u65f6\u6807\u6ce8RequiresPerms\u548cAlowAnonymous");
        }
        if (rp != null) {
            return rp.value().trim();
        }
        if (anon != null) {
            return "";
        }
        return null;
    }

    private String parsePermFromMethod(Method urlMethod) {
        RequiresPerms rp = urlMethod.getAnnotation(RequiresPerms.class);
        AlowAnonymous anon = urlMethod.getAnnotation(AlowAnonymous.class);
        if (rp != null && anon != null) {
            throw new IllegalStateException("\u4e0d\u80fd\u540c\u65f6\u6807\u6ce8RequiresPerms\u548cAlowAnonymous");
        }
        if (rp != null) {
            return rp.value().trim();
        }
        if (anon != null) {
            return "";
        }
        return null;
    }

    private String concatPerms(String parentPerm, String childPerm) {
        if (parentPerm == null && childPerm == null) {
            return null;
        }
        if ("".equals(parentPerm) && childPerm == null) {
            return "anon";
        }
        if ("".equals(childPerm)) {
            return "anon";
        }
        String perm = "";
        perm = Strings.isNullOrEmpty((String)parentPerm) ? childPerm : (Strings.isNullOrEmpty((String)childPerm) ? parentPerm + ":" + BASE_AUTH_PERM_NAME : parentPerm.concat(":").concat(childPerm));
        return perm;
    }
}

