/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.jwtshiro;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import com.github.davidfantasy.jwtshiro.JWTShiroAutoConfiguration;
import com.github.davidfantasy.jwtshiro.JWTShiroProperties;
import com.google.common.base.Strings;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTHelper {
    private static final Logger logger = LoggerFactory.getLogger(JWTShiroAutoConfiguration.class);
    private JWTShiroProperties prop;

    protected JWTHelper(JWTShiroProperties prop) {
        this.prop = prop;
    }

    public DecodedJWT verify(String token, String account, String secret) {
        try {
            Algorithm algorithm = Algorithm.HMAC256((String)secret);
            JWTVerifier verifier = JWT.require((Algorithm)algorithm).acceptExpiresAt((long)(this.prop.getMaxIdleMinute() * 60)).build();
            DecodedJWT jwt = verifier.verify(token);
            return jwt;
        }
        catch (JWTVerificationException exception) {
            return null;
        }
    }

    public String getAccount(String token) {
        if (Strings.isNullOrEmpty((String)token)) {
            return null;
        }
        try {
            DecodedJWT jwt = JWT.decode((String)token);
            return jwt.getClaim(this.prop.getAccountAlias()).asString();
        }
        catch (JWTDecodeException e) {
            logger.error("decode token error", (Throwable)e);
            return null;
        }
    }

    public String sign(String account, String secret, long expireAfterMinutes) {
        Date expireAfter = new Date(System.currentTimeMillis() + expireAfterMinutes * 60L * 1000L);
        System.out.println(System.currentTimeMillis() + ":" + expireAfter.getTime());
        Algorithm algorithm = Algorithm.HMAC256((String)secret);
        return JWT.create().withClaim(this.prop.getAccountAlias(), account).withExpiresAt(expireAfter).sign(algorithm);
    }

    public String sign(String account, String secret) {
        return this.sign(account, secret, this.prop.getMaxAliveMinute());
    }
}

