/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.jwtshiro;

import com.github.davidfantasy.jwtshiro.AnnotationFilterRuleLoader;
import com.github.davidfantasy.jwtshiro.JWTHelper;
import com.github.davidfantasy.jwtshiro.JWTShiroProperties;
import com.github.davidfantasy.jwtshiro.JWTUserAuthService;
import com.github.davidfantasy.jwtshiro.TokenRefreshInterceptor;
import com.github.davidfantasy.jwtshiro.shiro.JWTAuthFilter;
import com.github.davidfantasy.jwtshiro.shiro.JWTPermFilter;
import com.github.davidfantasy.jwtshiro.shiro.JWTShiroRealm;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.servlet.Filter;
import org.apache.shiro.mgt.DefaultSessionStorageEvaluator;
import org.apache.shiro.mgt.DefaultSubjectDAO;
import org.apache.shiro.mgt.SecurityManager;
import org.apache.shiro.mgt.SessionStorageEvaluator;
import org.apache.shiro.mgt.SubjectDAO;
import org.apache.shiro.realm.Realm;
import org.apache.shiro.spring.web.ShiroFilterFactoryBean;
import org.apache.shiro.web.mgt.DefaultWebSecurityManager;
import org.apache.shiro.web.servlet.AbstractShiroFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcAutoConfiguration;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.CorsRegistry;
import org.springframework.web.servlet.config.annotation.InterceptorRegistration;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.mvc.method.annotation.RequestMappingHandlerMapping;

@Configuration
@ConditionalOnBean(value={JWTUserAuthService.class})
@EnableConfigurationProperties(value={JWTShiroProperties.class})
public class JWTShiroAutoConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(JWTShiroAutoConfiguration.class);
    @Autowired
    private JWTShiroProperties prop;

    @PostConstruct
    public void afterConstruct() {
        logger.info("\u5f00\u59cb\u914d\u7f6ejwt-shiro\uff0c\u5f53\u524d\u7684\u9ed8\u8ba4\u914d\u7f6e\u4e3a\uff1a" + this.prop);
        if (this.prop.getMaxIdleMinute() < this.prop.getMaxAliveMinute()) {
            throw new IllegalArgumentException("accessToken\u7684maxIdleMinute\u5fc5\u987b\u5927\u4e8emaxAliveMinute\uff0c\u8bf7\u68c0\u67e5\u914d\u7f6e");
        }
    }

    @Bean(value={"securityManager"})
    public DefaultWebSecurityManager getManager(JWTShiroRealm shiroRealm) {
        DefaultWebSecurityManager manager = new DefaultWebSecurityManager();
        manager.setRealm((Realm)shiroRealm);
        DefaultSubjectDAO subjectDAO = new DefaultSubjectDAO();
        DefaultSessionStorageEvaluator defaultSessionStorageEvaluator = new DefaultSessionStorageEvaluator();
        defaultSessionStorageEvaluator.setSessionStorageEnabled(false);
        subjectDAO.setSessionStorageEvaluator((SessionStorageEvaluator)defaultSessionStorageEvaluator);
        manager.setSubjectDAO((SubjectDAO)subjectDAO);
        return manager;
    }

    @Bean(value={"shiroFilter"})
    public ShiroFilterFactoryBean factory(DefaultWebSecurityManager securityManager, JWTUserAuthService userAuthService) {
        ShiroFilterFactoryBean factoryBean = new ShiroFilterFactoryBean();
        HashMap filters = Maps.newHashMap();
        filters.put("jwtAuthc", new JWTAuthFilter(this.prop.getHeaderKeyOfToken(), userAuthService));
        filters.put("jwtPerm", new JWTPermFilter(userAuthService));
        factoryBean.setFilters((Map)filters);
        factoryBean.setSecurityManager((SecurityManager)securityManager);
        return factoryBean;
    }

    @Bean(value={"shiroRealm"})
    public JWTShiroRealm shiroRealm(JWTUserAuthService userAuthService, JWTHelper jwtHelper) {
        return new JWTShiroRealm(userAuthService, jwtHelper);
    }

    @Bean
    public FilterRegistrationBean delegatingFilterProxy(AbstractShiroFilter shiroFilter) {
        String[] patterns;
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean();
        filterRegistrationBean.setFilter((Filter)shiroFilter);
        for (String urlPattern : patterns = this.prop.getUrlPattern().split(",")) {
            if (urlPattern.endsWith("**")) {
                urlPattern = urlPattern.substring(0, urlPattern.length() - 1);
            }
            logger.info("\u6dfb\u52a0shiro filter\u5339\u914dURL\u89c4\u5219\uff1a" + urlPattern);
            filterRegistrationBean.addUrlPatterns(new String[]{urlPattern});
        }
        return filterRegistrationBean;
    }

    @Bean
    public JWTHelper getJWTHelper() {
        return new JWTHelper(this.prop);
    }

    @Bean
    @ConditionalOnProperty(prefix="jwt-shiro", name={"enable-auto-refresh-token"}, havingValue="true")
    public TokenRefreshInterceptor tokenRefreshInterceptor(JWTHelper helper, JWTUserAuthService userLoader) {
        return new TokenRefreshInterceptor(userLoader, helper, this.prop.getHeaderKeyOfToken());
    }

    @Configuration
    @AutoConfigureAfter(value={WebMvcAutoConfiguration.class})
    public static class FilterRuleLoaderConfigurer {
        private AnnotationFilterRuleLoader ruleLoder;
        @Autowired
        private AbstractShiroFilter shiroFilter;
        @Autowired
        private RequestMappingHandlerMapping handlerMapping;

        @PostConstruct
        public void init() {
            this.ruleLoder = new AnnotationFilterRuleLoader(this.shiroFilter, this.handlerMapping);
            this.ruleLoder.refreshRuleMapping();
        }
    }

    @Configuration
    @ConditionalOnProperty(prefix="jwt-shiro", name={"enable-auto-refresh-token"}, havingValue="true")
    public static class JWTWebMvcConfigurer
    implements WebMvcConfigurer {
        @Autowired
        private TokenRefreshInterceptor tokenRefreshInterceptor;
        @Autowired
        private JWTShiroProperties prop;

        public void addInterceptors(InterceptorRegistry registry) {
            InterceptorRegistration reg = registry.addInterceptor((HandlerInterceptor)this.tokenRefreshInterceptor);
            String[] patterns = this.prop.getUrlPattern().split(",");
            logger.info("\u542f\u7528token\u81ea\u52a8\u5237\u65b0\u673a\u5236\uff0c\u5df2\u6ce8\u518cTokenRefreshInterceptor");
            for (String urlPattern : patterns) {
                logger.info("TokenRefreshInterceptor\u5339\u914dURL\u89c4\u5219\uff1a" + urlPattern);
                reg.addPathPatterns(new String[]{urlPattern});
            }
        }

        public void addCorsMappings(CorsRegistry registry) {
            String[] urls;
            for (String url : urls = this.prop.getUrlPattern().split(",")) {
                registry.addMapping(url).exposedHeaders(new String[]{this.prop.getHeaderKeyOfToken()});
            }
        }
    }
}

