/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.jwtshiro;

import com.github.davidfantasy.jwtshiro.JWTHelper;
import com.github.davidfantasy.jwtshiro.JWTUserAuthService;
import com.github.davidfantasy.jwtshiro.UserInfo;
import com.github.davidfantasy.jwtshiro.shiro.JWTPrincipal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.subject.Subject;
import org.springframework.web.servlet.HandlerInterceptor;

public class TokenRefreshInterceptor
implements HandlerInterceptor {
    private JWTUserAuthService userAuthService;
    private JWTHelper jwtHelper;
    private String headerKeyOfToken;

    protected TokenRefreshInterceptor(JWTUserAuthService userAuthService, JWTHelper jwtHelper, String headerKeyOfToken) {
        this.jwtHelper = jwtHelper;
        this.userAuthService = userAuthService;
        this.headerKeyOfToken = headerKeyOfToken;
    }

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        Subject subject = SecurityUtils.getSubject();
        JWTPrincipal principal = (JWTPrincipal)subject.getPrincipal();
        if (principal != null && System.currentTimeMillis() > principal.getExpiresAt()) {
            UserInfo user = this.userAuthService.getUserInfo(principal.getAccount());
            String newToken = this.jwtHelper.sign(user.getAccount(), user.getSecret());
            response.setHeader(this.headerKeyOfToken, newToken);
        }
        return true;
    }
}

