/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.jwtshiro.shiro;

import com.github.davidfantasy.jwtshiro.JWTUserAuthService;
import com.github.davidfantasy.jwtshiro.shiro.JWTToken;
import com.google.common.base.Strings;
import java.io.IOException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.web.filter.AccessControlFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JWTAuthFilter
extends AccessControlFilter {
    private static final Logger logger = LoggerFactory.getLogger(JWTAuthFilter.class);
    private String headerKeyOfToken;
    private JWTUserAuthService userAuthService;

    public JWTAuthFilter(String headerKeyOfToken, JWTUserAuthService userAuthService) {
        this.headerKeyOfToken = headerKeyOfToken;
        this.userAuthService = userAuthService;
    }

    protected boolean isAccessAllowed(ServletRequest request, ServletResponse response, Object mappedValue) throws Exception {
        HttpServletRequest req = (HttpServletRequest)request;
        String authorization = req.getHeader(this.headerKeyOfToken);
        if (Strings.isNullOrEmpty((String)authorization)) {
            authorization = req.getParameter(this.headerKeyOfToken);
        }
        JWTToken token = new JWTToken(authorization);
        try {
            this.getSubject(request, response).login((AuthenticationToken)token);
        }
        catch (Exception e) {
            logger.error("\u8ba4\u8bc1\u5931\u8d25:" + e.getMessage());
            return false;
        }
        return true;
    }

    protected boolean onAccessDenied(ServletRequest request, ServletResponse response) throws IOException {
        this.userAuthService.onAuthenticationFailed((HttpServletRequest)request, (HttpServletResponse)response);
        return false;
    }
}

