/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidfantasy.jwtshiro.shiro;

import com.auth0.jwt.interfaces.DecodedJWT;
import com.github.davidfantasy.jwtshiro.JWTHelper;
import com.github.davidfantasy.jwtshiro.JWTUserAuthService;
import com.github.davidfantasy.jwtshiro.UserInfo;
import com.github.davidfantasy.jwtshiro.shiro.JWTPrincipal;
import com.github.davidfantasy.jwtshiro.shiro.JWTToken;
import org.apache.shiro.authc.AuthenticationException;
import org.apache.shiro.authc.AuthenticationInfo;
import org.apache.shiro.authc.AuthenticationToken;
import org.apache.shiro.authc.SimpleAuthenticationInfo;
import org.apache.shiro.authz.AuthorizationInfo;
import org.apache.shiro.authz.SimpleAuthorizationInfo;
import org.apache.shiro.realm.AuthorizingRealm;
import org.apache.shiro.subject.PrincipalCollection;

public class JWTShiroRealm
extends AuthorizingRealm {
    private JWTUserAuthService userAuthService;
    private JWTHelper jwtHelper;

    public JWTShiroRealm(JWTUserAuthService userAuthService, JWTHelper jwtHelper) {
        this.jwtHelper = jwtHelper;
        this.userAuthService = userAuthService;
    }

    public boolean supports(AuthenticationToken token) {
        return token instanceof JWTToken;
    }

    protected AuthorizationInfo doGetAuthorizationInfo(PrincipalCollection principals) {
        JWTPrincipal principal = (JWTPrincipal)principals.getPrimaryPrincipal();
        SimpleAuthorizationInfo authInfo = new SimpleAuthorizationInfo();
        UserInfo up = this.userAuthService.getUserInfo(principal.getAccount());
        if (up != null && up.getPermissions() != null) {
            authInfo.addStringPermissions(up.getPermissions());
        }
        return authInfo;
    }

    protected AuthenticationInfo doGetAuthenticationInfo(AuthenticationToken auth) throws AuthenticationException {
        String token = (String)auth.getCredentials();
        String username = this.jwtHelper.getAccount(token);
        if (username == null) {
            throw new AuthenticationException("\u65e0\u6548\u7684\u8bf7\u6c42");
        }
        UserInfo user = this.userAuthService.getUserInfo(username);
        if (user == null) {
            throw new AuthenticationException("\u672a\u627e\u5230\u7528\u6237\u4fe1\u606f");
        }
        DecodedJWT jwt = this.jwtHelper.verify(token, username, user.getSecret());
        if (jwt == null) {
            throw new AuthenticationException("token\u5df2\u7ecf\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55");
        }
        JWTPrincipal principal = new JWTPrincipal();
        principal.setAccount(user.getAccount());
        principal.setExpiresAt(jwt.getExpiresAt().getTime());
        return new SimpleAuthenticationInfo((Object)principal, (Object)token, this.getName());
    }
}

