/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.BaseUrlFactory;
import com.github.davidmoten.aws.lw.client.Credentials;
import com.github.davidmoten.aws.lw.client.ExceptionFactory;
import com.github.davidmoten.aws.lw.client.HttpClient;
import com.github.davidmoten.aws.lw.client.Request;
import com.github.davidmoten.aws.lw.client.Response;
import com.github.davidmoten.aws.lw.client.internal.Clock;
import com.github.davidmoten.aws.lw.client.internal.Environment;
import com.github.davidmoten.aws.lw.client.internal.ExceptionFactoryExtended;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Predicate;

public final class Client {
    private final Clock clock;
    private final String serviceName;
    private final Optional<String> region;
    private final Credentials credentials;
    private final HttpClient httpClient;
    private final int connectTimeoutMs;
    private final int readTimeoutMs;
    private final ExceptionFactory exceptionFactory;
    private final BaseUrlFactory baseUrlFactory;

    private Client(Clock clock, String serviceName, Optional<String> region, Credentials credentials, HttpClient httpClient, int connectTimeoutMs, int readTimeoutMs, ExceptionFactory exceptionFactory, BaseUrlFactory baseUrlFactory) {
        this.clock = clock;
        this.serviceName = serviceName;
        this.region = region;
        this.credentials = credentials;
        this.httpClient = httpClient;
        this.connectTimeoutMs = connectTimeoutMs;
        this.readTimeoutMs = readTimeoutMs;
        this.exceptionFactory = exceptionFactory;
        this.baseUrlFactory = baseUrlFactory;
    }

    public static Builder service(String serviceName) {
        Preconditions.checkNotNull(serviceName);
        return new Builder(serviceName);
    }

    public static Builder s3() {
        return Client.service("s3");
    }

    public static Builder sqs() {
        return Client.service("sqs");
    }

    public static Builder iam() {
        return Client.service("iam");
    }

    public static Builder ec2() {
        return Client.service("ec2");
    }

    public static Builder sns() {
        return Client.service("sns");
    }

    public static Builder lambda() {
        return Client.service("lambda");
    }

    String serviceName() {
        return this.serviceName;
    }

    public Optional<String> region() {
        return this.region;
    }

    Credentials credentials() {
        return this.credentials;
    }

    HttpClient httpClient() {
        return this.httpClient;
    }

    Clock clock() {
        return this.clock;
    }

    ExceptionFactory exceptionFactory() {
        return this.exceptionFactory;
    }

    BaseUrlFactory baseUrlFactory() {
        return this.baseUrlFactory;
    }

    int connectTimeoutMs() {
        return this.connectTimeoutMs;
    }

    int readTimeoutMs() {
        return this.readTimeoutMs;
    }

    public Request url(String url) {
        Preconditions.checkNotNull(url);
        return new Request(this, url, new String[0]);
    }

    public Request path(String ... segments) {
        Preconditions.checkNotNull(segments, "segments cannot be null");
        return new Request(this, null, segments);
    }

    public Request query(String name, String value) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        return this.path("").query(name, value);
    }

    public Request attributePrefix(String attributePrefix) {
        return this.path("").attributePrefix(attributePrefix);
    }

    public Request attribute(String name, String value) {
        Preconditions.checkNotNull(name, "name cannot be null");
        Preconditions.checkNotNull(value, "value cannot be null");
        return this.path("").attribute(name, value);
    }

    public static final class Builder4 {
        private final Builder b;

        private Builder4(Builder b) {
            this.b = b;
        }

        public Builder4 baseUrlFactory(BaseUrlFactory factory) {
            this.b.baseUrlFactory = factory;
            return this;
        }

        public Builder4 httpClient(HttpClient httpClient) {
            this.b.httpClient = httpClient;
            return this;
        }

        public Builder4 connectTimeout(long duration, TimeUnit unit) {
            Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
            Preconditions.checkNotNull(unit, "unit cannot be null");
            this.b.connectTimeoutMs = (int)unit.toMillis(duration);
            return this;
        }

        public Builder4 readTimeout(long duration, TimeUnit unit) {
            Preconditions.checkArgument(duration >= 0L, "duration cannot be negative");
            Preconditions.checkNotNull(unit, "unit cannot be null");
            this.b.readTimeoutMs = (int)unit.toMillis(duration);
            return this;
        }

        public Builder4 exceptionFactory(ExceptionFactory exceptionFactory) {
            this.b.exceptionFactory = exceptionFactory;
            return this;
        }

        public Builder4 exception(Predicate<? super Response> predicate, Function<? super Response, ? extends RuntimeException> factory) {
            this.b.exceptionFactory = new ExceptionFactoryExtended(this.b.exceptionFactory, predicate, factory);
            return this;
        }

        public Builder4 clock(Clock clock) {
            this.b.clock = clock;
            return this;
        }

        public Client build() {
            return new Client(this.b.clock, this.b.serviceName, this.b.region, this.b.credentials, this.b.httpClient, this.b.connectTimeoutMs, this.b.readTimeoutMs, this.b.exceptionFactory, this.b.baseUrlFactory);
        }
    }

    public static final class Builder3 {
        private final Builder b;

        private Builder3(Builder b) {
            this.b = b;
        }

        public Builder4 secretKey(String secretKey) {
            Preconditions.checkNotNull(secretKey);
            this.b.credentials = Credentials.of(this.b.accessKey, secretKey);
            return new Builder4(this.b);
        }
    }

    public static final class Builder2 {
        private final Builder b;

        private Builder2(Builder b) {
            this.b = b;
        }

        public Builder4 credentialsFromEnvironment() {
            this.b.credentials = this.b.environment.credentials();
            return new Builder4(this.b);
        }

        public Builder4 credentialsFromSystemProperties() {
            return this.credentials(Credentials.fromSystemProperties());
        }

        public Builder3 accessKey(String accessKey) {
            Preconditions.checkNotNull(accessKey);
            this.b.accessKey = accessKey;
            return new Builder3(this.b);
        }

        public Builder4 credentials(Credentials credentials) {
            Preconditions.checkNotNull(credentials);
            this.b.credentials = credentials;
            return new Builder4(this.b);
        }
    }

    public static final class Builder {
        private final String serviceName;
        private Optional<String> region = Optional.empty();
        private String accessKey;
        private Credentials credentials;
        private HttpClient httpClient = HttpClient.defaultClient();
        private int connectTimeoutMs = 30000;
        private int readTimeoutMs = 300000;
        private ExceptionFactory exceptionFactory = ExceptionFactory.DEFAULT;
        private Clock clock = Clock.DEFAULT;
        private Environment environment = Environment.instance();
        private BaseUrlFactory baseUrlFactory = BaseUrlFactory.DEFAULT;

        private Builder(String serviceName) {
            this.serviceName = serviceName;
        }

        Builder environment(Environment environment) {
            Preconditions.checkNotNull(environment, "environment cannot be null");
            this.environment = environment;
            return this;
        }

        public Builder4 defaultClient() {
            return this.regionFromEnvironment().credentialsFromEnvironment();
        }

        public Builder4 from(Client client) {
            Preconditions.checkNotNull(client, "client cannot be null");
            this.region = client.region;
            this.credentials = client.credentials;
            this.httpClient = client.httpClient;
            this.connectTimeoutMs = client.connectTimeoutMs;
            this.readTimeoutMs = client.readTimeoutMs;
            this.exceptionFactory = client.exceptionFactory;
            return new Builder4(this);
        }

        public Builder2 regionFromEnvironment() {
            return this.region(this.environment.get("AWS_REGION"));
        }

        public Builder2 region(Optional<String> region) {
            Preconditions.checkNotNull(region, "region cannot be null");
            this.region = region;
            return new Builder2(this);
        }

        public Builder2 region(String region) {
            Preconditions.checkNotNull(region, "region cannot be null");
            return this.region(Optional.of(region));
        }

        public Builder2 regionNone() {
            return this.region(Optional.empty());
        }
    }
}

