/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.Client;
import com.github.davidmoten.aws.lw.client.HttpMethod;
import com.github.davidmoten.aws.lw.client.MaxAttemptsExceededException;
import com.github.davidmoten.aws.lw.client.Request;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import com.github.davidmoten.aws.lw.client.xml.builder.Xml;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class MultipartOutputStream
extends OutputStream {
    private final Client s3;
    private final String bucket;
    private final String key;
    private final String uploadId;
    private final ExecutorService executor;
    private final ByteArrayOutputStream bytes;
    private final byte[] singleByte = new byte[1];
    private final long partTimeoutMs;
    private final int maxAttempts;
    private final long retryIntervalMs;
    private final int partSize;
    private final List<Future<String>> futures = new CopyOnWriteArrayList<Future<String>>();
    private int nextPart = 1;

    MultipartOutputStream(Client s3, String bucket, String key, Function<? super Request, ? extends Request> transformCreate, ExecutorService executor, long partTimeoutMs, int maxAttempts, long retryIntervalMs, int partSize) {
        Preconditions.checkNotNull(s3);
        Preconditions.checkNotNull(bucket);
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(transformCreate);
        Preconditions.checkNotNull(executor);
        Preconditions.checkArgument(partTimeoutMs > 0L);
        Preconditions.checkArgument(maxAttempts >= 1);
        Preconditions.checkArgument(retryIntervalMs >= 0L);
        Preconditions.checkArgument(partSize >= 0x500000);
        this.s3 = s3;
        this.bucket = bucket;
        this.key = key;
        this.executor = executor;
        this.partTimeoutMs = partTimeoutMs;
        this.maxAttempts = maxAttempts;
        this.retryIntervalMs = retryIntervalMs;
        this.partSize = partSize;
        this.bytes = new ByteArrayOutputStream();
        this.uploadId = transformCreate.apply(s3.path(bucket, key).query("uploads").method(HttpMethod.POST)).responseAsXml().content("UploadId");
    }

    public void abort() {
        this.futures.forEach(f -> f.cancel(true));
        this.s3.path(this.bucket, this.key).query("uploadId", this.uploadId).method(HttpMethod.DELETE).execute();
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        while (len > 0) {
            int remaining = this.partSize - this.bytes.size();
            int n = Math.min(remaining, len);
            this.bytes.write(b, off, n);
            off += n;
            len -= n;
            if (this.bytes.size() != this.partSize) continue;
            this.submitPart();
        }
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    private void submitPart() {
        int part = this.nextPart++;
        byte[] body = this.bytes.toByteArray();
        this.bytes.reset();
        Future<String> future = this.executor.submit(() -> this.retry(() -> this.s3.path(this.bucket, this.key).method(HttpMethod.PUT).query("partNumber", "" + part).query("uploadId", this.uploadId).requestBody(body).readTimeout(this.partTimeoutMs, TimeUnit.MILLISECONDS).responseExpectStatusCode(200).firstHeader("ETag").get().replace("\"", ""), "on part " + part));
        this.futures.add(future);
    }

    private <T> T retry(Callable<T> callable, String description) {
        int attempt = 1;
        while (true) {
            try {
                return callable.call();
            }
            catch (Throwable e) {
                if (++attempt > this.maxAttempts) {
                    throw new MaxAttemptsExceededException("exceeded max attempts " + this.maxAttempts + " " + description, e);
                }
                MultipartOutputStream.sleep(this.retryIntervalMs);
                continue;
            }
            break;
        }
    }

    private static void sleep(long duration) {
        try {
            Thread.sleep(duration);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    @Override
    public void close() throws IOException {
        if (this.bytes.size() > 0) {
            this.submitPart();
        }
        List etags = this.futures.stream().map(future -> this.getResult((Future<String>)future)).collect(Collectors.toList());
        Xml xml = Xml.create("CompleteMultipartUpload").attribute("xmlns", "http:s3.amazonaws.com/doc/2006-03-01/");
        for (int i = 0; i < etags.size(); ++i) {
            xml = xml.element("Part").element("ETag").content((String)etags.get(i)).up().element("PartNumber").content(String.valueOf(i + 1)).up().up();
        }
        String xmlFinal = xml.toString();
        this.retry(() -> {
            this.s3.path(this.bucket, this.key).method(HttpMethod.POST).query("uploadId", this.uploadId).header("Content-Type", "application/xml").unsignedPayload().requestBody(xmlFinal).execute();
            return null;
        }, "while completing multipart upload");
    }

    private String getResult(Future<String> future) {
        try {
            return future.get(this.partTimeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (Throwable e) {
            this.abort();
            throw new RuntimeException(e);
        }
    }

    @Override
    public void write(int b) throws IOException {
        this.singleByte[0] = (byte)b;
        this.write(this.singleByte, 0, 1);
    }
}

