/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client;

import com.github.davidmoten.aws.lw.client.Credentials;
import com.github.davidmoten.aws.lw.client.HttpClient;
import com.github.davidmoten.aws.lw.client.HttpMethod;
import com.github.davidmoten.aws.lw.client.ResponseInputStream;
import com.github.davidmoten.aws.lw.client.internal.Clock;
import com.github.davidmoten.aws.lw.client.internal.auth.AwsSignatureVersion4;
import com.github.davidmoten.aws.lw.client.internal.util.Preconditions;
import com.github.davidmoten.aws.lw.client.internal.util.Util;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

final class RequestHelper {
    private static final char QUERY_PARAMETER_SEPARATOR = '&';
    private static final char QUERY_PARAMETER_VALUE_SEPARATOR = '=';

    private RequestHelper() {
    }

    static void put(Map<String, List<String>> map, String name, String value) {
        Preconditions.checkNotNull(map);
        Preconditions.checkNotNull(name);
        Preconditions.checkNotNull(value);
        List<String> list = map.get(name);
        if (list == null) {
            list = new ArrayList<String>();
            map.put(name, list);
        }
        list.add(value);
    }

    static Map<String, String> combineHeaders(Map<String, List<String>> headers) {
        Preconditions.checkNotNull(headers);
        return headers.entrySet().stream().collect(Collectors.toMap(x -> (String)x.getKey(), x -> ((List)x.getValue()).stream().collect(Collectors.joining(","))));
    }

    static String presignedUrl(Clock clock, String url, String method, Map<String, String> headers, byte[] requestBody, String serviceName, Optional<String> regionName, Credentials credentials, int connectTimeoutMs, int readTimeoutMs, long expirySeconds, boolean signPayload) {
        String contentHashString;
        URL endpointUrl = Util.toUrl(url);
        HashMap<String, String> h = new HashMap<String, String>(headers);
        if (RequestHelper.isEmpty(requestBody)) {
            contentHashString = "UNSIGNED-PAYLOAD";
            h.put("x-amz-content-sha256", "");
        } else if (!signPayload) {
            contentHashString = "UNSIGNED-PAYLOAD";
            h.put("x-amz-content-sha256", contentHashString);
        } else {
            byte[] contentHash = Util.sha256(requestBody);
            contentHashString = Util.toHex(contentHash);
            h.put("content-length", "" + requestBody.length);
            h.put("x-amz-content-sha256", contentHashString);
        }
        List<Parameter> parameters = RequestHelper.extractQueryParameters(endpointUrl);
        HashMap<String, String> q = new HashMap<String, String>();
        parameters.forEach(p -> q.put(p.name, p.value));
        q.put("X-Amz-Expires", "" + expirySeconds);
        String authorizationQueryParameters = AwsSignatureVersion4.computeSignatureForQueryAuth(endpointUrl, method, serviceName, regionName, clock, h, q, contentHashString, credentials.accessKey(), credentials.secretKey(), credentials.sessionToken());
        String u = endpointUrl.toString();
        String presignedUrl = u.contains("?") ? u + "&" + authorizationQueryParameters : u + "?" + authorizationQueryParameters;
        return presignedUrl;
    }

    private static void includeTokenIfPresent(Credentials credentials, Map<String, String> h) {
        if (credentials.sessionToken().isPresent()) {
            h.put("x-amz-security-token", credentials.sessionToken().get());
        }
    }

    static ResponseInputStream request(Clock clock, HttpClient httpClient, String url, HttpMethod method, Map<String, String> headers, byte[] requestBody, String serviceName, Optional<String> regionName, Credentials credentials, int connectTimeoutMs, int readTimeoutMs, boolean signPayload) throws IOException {
        String contentHashString;
        URL endpointUrl = Util.toUrl(url);
        HashMap<String, String> h = new HashMap<String, String>(headers);
        if (RequestHelper.isEmpty(requestBody)) {
            contentHashString = "e3b0c44298fc1c149afbf4c8996fb92427ae41e4649b934ca495991b7852b855";
        } else {
            if (!signPayload) {
                contentHashString = "UNSIGNED-PAYLOAD";
            } else {
                byte[] contentHash = Util.sha256(requestBody);
                contentHashString = Util.toHex(contentHash);
            }
            h.put("content-length", "" + requestBody.length);
        }
        h.put("x-amz-content-sha256", contentHashString);
        RequestHelper.includeTokenIfPresent(credentials, h);
        List<Parameter> parameters = RequestHelper.extractQueryParameters(endpointUrl);
        HashMap<String, String> q = new HashMap<String, String>();
        parameters.forEach(p -> q.put(p.name, p.value));
        String authorization = AwsSignatureVersion4.computeSignatureForAuthorizationHeader(endpointUrl, method.toString(), serviceName, regionName.orElse("us-east-1"), clock, h, q, contentHashString, credentials.accessKey(), credentials.secretKey());
        h.put("Authorization", authorization);
        return httpClient.request(endpointUrl, method.toString(), h, requestBody, connectTimeoutMs, readTimeoutMs);
    }

    private static List<Parameter> extractQueryParameters(URL endpointUrl) {
        String query = endpointUrl.getQuery();
        if (query == null) {
            return Collections.emptyList();
        }
        return RequestHelper.extractQueryParameters(query);
    }

    static List<Parameter> extractQueryParameters(String rawQuery) {
        ArrayList<Parameter> results = new ArrayList<Parameter>();
        int endIndex = rawQuery.length() - 1;
        int index = 0;
        while (index <= endIndex) {
            String value;
            String name;
            int nameValueSeparatorIndex = rawQuery.indexOf(61, index);
            if (nameValueSeparatorIndex < 0) {
                name = rawQuery.substring(index);
                value = null;
                index = endIndex + 1;
            } else {
                int parameterSeparatorIndex = rawQuery.indexOf(38, nameValueSeparatorIndex);
                if (parameterSeparatorIndex < 0) {
                    parameterSeparatorIndex = endIndex + 1;
                }
                name = rawQuery.substring(index, nameValueSeparatorIndex);
                value = rawQuery.substring(nameValueSeparatorIndex + 1, parameterSeparatorIndex);
                index = parameterSeparatorIndex + 1;
            }
            results.add(RequestHelper.parameter(name, value, "UTF-8"));
        }
        return results;
    }

    static Parameter parameter(String name, String value, String charset) {
        try {
            return new Parameter(URLDecoder.decode(name, charset), value == null ? value : URLDecoder.decode(value, charset));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static boolean isEmpty(byte[] array) {
        return array == null || array.length == 0;
    }

    static final class Parameter {
        final String name;
        final String value;

        Parameter(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }
}

