/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.internal;

import com.github.davidmoten.aws.lw.client.ExceptionFactory;
import com.github.davidmoten.aws.lw.client.Response;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;

public class ExceptionFactoryExtended
implements ExceptionFactory {
    private final ExceptionFactory factory;
    private final Predicate<? super Response> predicate;
    private final Function<? super Response, ? extends RuntimeException> function;

    public ExceptionFactoryExtended(ExceptionFactory factory, Predicate<? super Response> predicate, Function<? super Response, ? extends RuntimeException> function) {
        this.factory = factory;
        this.predicate = predicate;
        this.function = function;
    }

    @Override
    public Optional<? extends RuntimeException> create(Response response) {
        if (this.predicate.test(response)) {
            return Optional.of(this.function.apply(response));
        }
        return this.factory.create(response);
    }
}

