/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.aws.lw.client.internal;

import com.github.davidmoten.aws.lw.client.HttpClient;
import com.github.davidmoten.aws.lw.client.ResponseInputStream;
import com.github.davidmoten.aws.lw.client.internal.util.Util;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import java.util.Map;

public final class HttpClientDefault
implements HttpClient {
    public static final HttpClientDefault INSTANCE = new HttpClientDefault();

    private HttpClientDefault() {
    }

    @Override
    public ResponseInputStream request(URL endpointUrl, String httpMethod, Map<String, String> headers, byte[] requestBody, int connectTimeoutMs, int readTimeoutMs) throws IOException {
        HttpURLConnection connection = Util.createHttpConnection(endpointUrl, httpMethod, headers, connectTimeoutMs, readTimeoutMs);
        return HttpClientDefault.request(connection, requestBody);
    }

    static ResponseInputStream request(HttpURLConnection connection, byte[] requestBody) {
        InputStream is;
        int responseCode;
        Map<String, List<String>> responseHeaders;
        try {
            if (requestBody != null) {
                OutputStream out = connection.getOutputStream();
                out.write(requestBody);
                out.flush();
            }
            responseHeaders = connection.getHeaderFields();
            responseCode = connection.getResponseCode();
            is = HttpClientDefault.isOk(responseCode) ? connection.getInputStream() : connection.getErrorStream();
            if (is == null) {
                is = Util.emptyInputStream();
            }
        }
        catch (IOException e) {
            try {
                connection.disconnect();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            throw new UncheckedIOException(e);
        }
        return new ResponseInputStream(connection, responseCode, responseHeaders, is);
    }

    private static boolean isOk(int responseCode) {
        return responseCode >= 200 && responseCode <= 299;
    }
}

