/*
 * Decompiled with CFR 0.152.
 */
package com.github.davidmoten.gitp;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="properties", defaultPhase=LifecyclePhase.INITIALIZE)
public class PropertiesMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project.build.outputDirectory}", property="outputDir", required=true)
    private File outputDirectory;
    @Parameter(defaultValue="git.properties", property="filename", required=true)
    private String filename;
    @Parameter(defaultValue="${project}")
    private MavenProject project;

    public void execute() throws MojoExecutionException {
        Log log = this.getLog();
        if (!this.outputDirectory.exists()) {
            this.outputDirectory.mkdirs();
        }
        File file = new File(this.outputDirectory, this.filename);
        try {
            String commitHash = this.run("git", "rev-parse", "HEAD");
            String commitHashShort = this.run("git", "rev-parse", "--short", "HEAD");
            String commitTime = this.run("git", "show", "-s", "--format=%ci", "HEAD");
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            map.put("git.commit.hash", commitHash.trim());
            map.put("git.commit.hash.short", commitHashShort.trim());
            map.put("git.commit.timestamp", commitTime.trim());
            try (FileWriter w = new FileWriter(file);){
                for (Map.Entry entry : map.entrySet()) {
                    String line = (String)entry.getKey() + "=" + (String)entry.getValue() + "\n";
                    w.write(line);
                    log.info((CharSequence)line);
                    this.project.getProperties().put(entry.getKey(), entry.getValue());
                }
            }
            log.info((CharSequence)("git properties written to " + file));
            log.info((CharSequence)"maven project properties also set with above key-values");
        }
        catch (IOException | InterruptedException e) {
            throw new MojoExecutionException(e.getMessage(), e);
        }
    }

    private String run(String ... command) throws IOException, InterruptedException {
        String message;
        Process p = new ProcessBuilder(new String[0]).command(Arrays.asList(command)).redirectErrorStream(true).start();
        p.waitFor(10L, TimeUnit.SECONDS);
        try (InputStream in = p.getInputStream();){
            byte[] bytes = PropertiesMojo.read(in);
            message = new String(bytes, StandardCharsets.UTF_8);
        }
        if (p.exitValue() != 0) {
            String cmd = Arrays.stream(command).collect(Collectors.joining(" "));
            this.getLog().error((CharSequence)("An error occurred calling\n" + cmd + ". The output of the command is:\n" + message));
            throw new RuntimeException("An error occurred calling '" + cmd + "'. See log for details.");
        }
        return message;
    }

    public static byte[] read(InputStream is) throws IOException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        byte[] buffer = new byte[8192];
        int len = is.read(buffer);
        while (len != -1) {
            os.write(buffer, 0, len);
            len = is.read(buffer);
        }
        return os.toByteArray();
    }
}

