/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.enums.AssociatedMenuBehavior;
import microsoft.dynamics.crm.enums.AssociatedMenuGroup;

@JsonPropertyOrder(value={"@odata.type", "Behavior", "Group", "Label", "Order", "IsCustomizable", "Icon", "ViewId", "AvailableOffline", "MenuId", "QueryApi"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AssociatedMenuConfiguration
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Behavior")
    protected AssociatedMenuBehavior behavior;
    @JsonProperty(value="Group")
    protected AssociatedMenuGroup group;
    @JsonProperty(value="Label")
    protected Label label;
    @JsonProperty(value="Order")
    protected Integer order;
    @JsonProperty(value="IsCustomizable")
    protected Boolean isCustomizable;
    @JsonProperty(value="Icon")
    protected String icon;
    @JsonProperty(value="ViewId")
    protected String viewId;
    @JsonProperty(value="AvailableOffline")
    protected Boolean availableOffline;
    @JsonProperty(value="MenuId")
    protected String menuId;
    @JsonProperty(value="QueryApi")
    protected String queryApi;

    protected AssociatedMenuConfiguration() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration";
    }

    @Property(name="Behavior")
    @JsonIgnore
    public Optional<AssociatedMenuBehavior> getBehavior() {
        return Optional.ofNullable(this.behavior);
    }

    public AssociatedMenuConfiguration withBehavior(AssociatedMenuBehavior behavior) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.behavior = behavior;
        return _x;
    }

    @Property(name="Group")
    @JsonIgnore
    public Optional<AssociatedMenuGroup> getGroup() {
        return Optional.ofNullable(this.group);
    }

    public AssociatedMenuConfiguration withGroup(AssociatedMenuGroup group) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.group = group;
        return _x;
    }

    @Property(name="Label")
    @JsonIgnore
    public Optional<Label> getLabel() {
        return Optional.ofNullable(this.label);
    }

    public AssociatedMenuConfiguration withLabel(Label label) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.label = label;
        return _x;
    }

    @Property(name="Order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(this.order);
    }

    public AssociatedMenuConfiguration withOrder(Integer order) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.order = order;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<Boolean> getIsCustomizable() {
        return Optional.ofNullable(this.isCustomizable);
    }

    public AssociatedMenuConfiguration withIsCustomizable(Boolean isCustomizable) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="Icon")
    @JsonIgnore
    public Optional<String> getIcon() {
        return Optional.ofNullable(this.icon);
    }

    public AssociatedMenuConfiguration withIcon(String icon) {
        Checks.checkIsAscii((String)icon);
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.icon = icon;
        return _x;
    }

    @Property(name="ViewId")
    @JsonIgnore
    public Optional<String> getViewId() {
        return Optional.ofNullable(this.viewId);
    }

    public AssociatedMenuConfiguration withViewId(String viewId) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.viewId = viewId;
        return _x;
    }

    @Property(name="AvailableOffline")
    @JsonIgnore
    public Optional<Boolean> getAvailableOffline() {
        return Optional.ofNullable(this.availableOffline);
    }

    public AssociatedMenuConfiguration withAvailableOffline(Boolean availableOffline) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.availableOffline = availableOffline;
        return _x;
    }

    @Property(name="MenuId")
    @JsonIgnore
    public Optional<String> getMenuId() {
        return Optional.ofNullable(this.menuId);
    }

    public AssociatedMenuConfiguration withMenuId(String menuId) {
        Checks.checkIsAscii((String)menuId);
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.menuId = menuId;
        return _x;
    }

    @Property(name="QueryApi")
    @JsonIgnore
    public Optional<String> getQueryApi() {
        return Optional.ofNullable(this.queryApi);
    }

    public AssociatedMenuConfiguration withQueryApi(String queryApi) {
        Checks.checkIsAscii((String)queryApi);
        AssociatedMenuConfiguration _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AssociatedMenuConfiguration");
        _x.queryApi = queryApi;
        return _x;
    }

    public AssociatedMenuConfiguration withUnmappedField(String name, String value) {
        AssociatedMenuConfiguration _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AssociatedMenuConfiguration _copy() {
        AssociatedMenuConfiguration _x = new AssociatedMenuConfiguration();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.behavior = this.behavior;
        _x.group = this.group;
        _x.label = this.label;
        _x.order = this.order;
        _x.isCustomizable = this.isCustomizable;
        _x.icon = this.icon;
        _x.viewId = this.viewId;
        _x.availableOffline = this.availableOffline;
        _x.menuId = this.menuId;
        _x.queryApi = this.queryApi;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AssociatedMenuConfiguration[");
        b.append("Behavior=");
        b.append((Object)this.behavior);
        b.append(", ");
        b.append("Group=");
        b.append((Object)this.group);
        b.append(", ");
        b.append("Label=");
        b.append(this.label);
        b.append(", ");
        b.append("Order=");
        b.append(this.order);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Icon=");
        b.append(this.icon);
        b.append(", ");
        b.append("ViewId=");
        b.append(this.viewId);
        b.append(", ");
        b.append("AvailableOffline=");
        b.append(this.availableOffline);
        b.append(", ");
        b.append("MenuId=");
        b.append(this.menuId);
        b.append(", ");
        b.append("QueryApi=");
        b.append(this.queryApi);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private AssociatedMenuBehavior behavior;
        private AssociatedMenuGroup group;
        private Label label;
        private Integer order;
        private Boolean isCustomizable;
        private String icon;
        private String viewId;
        private Boolean availableOffline;
        private String menuId;
        private String queryApi;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder behavior(AssociatedMenuBehavior behavior) {
            this.behavior = behavior;
            this.changedFields = this.changedFields.add("Behavior");
            return this;
        }

        public Builder group(AssociatedMenuGroup group) {
            this.group = group;
            this.changedFields = this.changedFields.add("Group");
            return this;
        }

        public Builder label(Label label) {
            this.label = label;
            this.changedFields = this.changedFields.add("Label");
            return this;
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = this.changedFields.add("Order");
            return this;
        }

        public Builder isCustomizable(Boolean isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public Builder icon(String icon) {
            this.icon = icon;
            this.changedFields = this.changedFields.add("Icon");
            return this;
        }

        public Builder viewId(String viewId) {
            this.viewId = viewId;
            this.changedFields = this.changedFields.add("ViewId");
            return this;
        }

        public Builder availableOffline(Boolean availableOffline) {
            this.availableOffline = availableOffline;
            this.changedFields = this.changedFields.add("AvailableOffline");
            return this;
        }

        public Builder menuId(String menuId) {
            this.menuId = menuId;
            this.changedFields = this.changedFields.add("MenuId");
            return this;
        }

        public Builder queryApi(String queryApi) {
            this.queryApi = queryApi;
            this.changedFields = this.changedFields.add("QueryApi");
            return this;
        }

        public AssociatedMenuConfiguration build() {
            AssociatedMenuConfiguration _x = new AssociatedMenuConfiguration();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AssociatedMenuConfiguration";
            _x.behavior = this.behavior;
            _x.group = this.group;
            _x.label = this.label;
            _x.order = this.order;
            _x.isCustomizable = this.isCustomizable;
            _x.icon = this.icon;
            _x.viewId = this.viewId;
            _x.availableOffline = this.availableOffline;
            _x.menuId = this.menuId;
            _x.queryApi = this.queryApi;
            return _x;
        }
    }
}

