/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.AuditDetail;

@JsonPropertyOrder(value={"@odata.type", "AuditDetails", "MoreRecords", "PagingCookie", "TotalRecordCount"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AuditDetailCollection
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="AuditDetails")
    protected List<AuditDetail> auditDetails;
    @JsonProperty(value="AuditDetails@nextLink")
    protected String auditDetailsNextLink;
    @JsonProperty(value="MoreRecords")
    protected Boolean moreRecords;
    @JsonProperty(value="PagingCookie")
    protected String pagingCookie;
    @JsonProperty(value="TotalRecordCount")
    protected Integer totalRecordCount;

    protected AuditDetailCollection() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AuditDetailCollection";
    }

    @Property(name="AuditDetails")
    @JsonIgnore
    public CollectionPage<AuditDetail> getAuditDetails() {
        return new CollectionPage(this.contextPath, AuditDetail.class, this.auditDetails, Optional.ofNullable(this.auditDetailsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="AuditDetails")
    @JsonIgnore
    public CollectionPage<AuditDetail> getAuditDetails(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, AuditDetail.class, this.auditDetails, Optional.ofNullable(this.auditDetailsNextLink), Collections.emptyList(), options);
    }

    @Property(name="MoreRecords")
    @JsonIgnore
    public Optional<Boolean> getMoreRecords() {
        return Optional.ofNullable(this.moreRecords);
    }

    public AuditDetailCollection withMoreRecords(Boolean moreRecords) {
        AuditDetailCollection _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AuditDetailCollection");
        _x.moreRecords = moreRecords;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(this.pagingCookie);
    }

    public AuditDetailCollection withPagingCookie(String pagingCookie) {
        Checks.checkIsAscii((String)pagingCookie);
        AuditDetailCollection _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AuditDetailCollection");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    @Property(name="TotalRecordCount")
    @JsonIgnore
    public Optional<Integer> getTotalRecordCount() {
        return Optional.ofNullable(this.totalRecordCount);
    }

    public AuditDetailCollection withTotalRecordCount(Integer totalRecordCount) {
        AuditDetailCollection _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AuditDetailCollection");
        _x.totalRecordCount = totalRecordCount;
        return _x;
    }

    public AuditDetailCollection withUnmappedField(String name, String value) {
        AuditDetailCollection _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AuditDetailCollection _copy() {
        AuditDetailCollection _x = new AuditDetailCollection();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.auditDetails = this.auditDetails;
        _x.moreRecords = this.moreRecords;
        _x.pagingCookie = this.pagingCookie;
        _x.totalRecordCount = this.totalRecordCount;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AuditDetailCollection[");
        b.append("AuditDetails=");
        b.append(this.auditDetails);
        b.append(", ");
        b.append("MoreRecords=");
        b.append(this.moreRecords);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append(", ");
        b.append("TotalRecordCount=");
        b.append(this.totalRecordCount);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<AuditDetail> auditDetails;
        private String auditDetailsNextLink;
        private Boolean moreRecords;
        private String pagingCookie;
        private Integer totalRecordCount;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder auditDetails(List<AuditDetail> auditDetails) {
            this.auditDetails = auditDetails;
            this.changedFields = this.changedFields.add("AuditDetails");
            return this;
        }

        public Builder auditDetails(AuditDetail ... auditDetails) {
            return this.auditDetails(Arrays.asList(auditDetails));
        }

        public Builder auditDetailsNextLink(String auditDetailsNextLink) {
            this.auditDetailsNextLink = auditDetailsNextLink;
            this.changedFields = this.changedFields.add("AuditDetails");
            return this;
        }

        public Builder moreRecords(Boolean moreRecords) {
            this.moreRecords = moreRecords;
            this.changedFields = this.changedFields.add("MoreRecords");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = this.changedFields.add("PagingCookie");
            return this;
        }

        public Builder totalRecordCount(Integer totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            this.changedFields = this.changedFields.add("TotalRecordCount");
            return this;
        }

        public AuditDetailCollection build() {
            AuditDetailCollection _x = new AuditDetailCollection();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AuditDetailCollection";
            _x.auditDetails = this.auditDetails;
            _x.auditDetailsNextLink = this.auditDetailsNextLink;
            _x.moreRecords = this.moreRecords;
            _x.pagingCookie = this.pagingCookie;
            _x.totalRecordCount = this.totalRecordCount;
            return _x;
        }
    }
}

