/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "Value", "CanBeChanged", "ManagedPropertyLogicalName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class BooleanManagedProperty
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Value")
    protected Boolean value;
    @JsonProperty(value="CanBeChanged")
    protected Boolean canBeChanged;
    @JsonProperty(value="ManagedPropertyLogicalName")
    protected String managedPropertyLogicalName;

    protected BooleanManagedProperty() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.BooleanManagedProperty";
    }

    @Property(name="Value")
    @JsonIgnore
    public Optional<Boolean> getValue() {
        return Optional.ofNullable(this.value);
    }

    public BooleanManagedProperty withValue(Boolean value) {
        BooleanManagedProperty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BooleanManagedProperty");
        _x.value = value;
        return _x;
    }

    @Property(name="CanBeChanged")
    @JsonIgnore
    public Optional<Boolean> getCanBeChanged() {
        return Optional.ofNullable(this.canBeChanged);
    }

    public BooleanManagedProperty withCanBeChanged(Boolean canBeChanged) {
        BooleanManagedProperty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BooleanManagedProperty");
        _x.canBeChanged = canBeChanged;
        return _x;
    }

    @Property(name="ManagedPropertyLogicalName")
    @JsonIgnore
    public Optional<String> getManagedPropertyLogicalName() {
        return Optional.ofNullable(this.managedPropertyLogicalName);
    }

    public BooleanManagedProperty withManagedPropertyLogicalName(String managedPropertyLogicalName) {
        Checks.checkIsAscii((String)managedPropertyLogicalName);
        BooleanManagedProperty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.BooleanManagedProperty");
        _x.managedPropertyLogicalName = managedPropertyLogicalName;
        return _x;
    }

    public BooleanManagedProperty withUnmappedField(String name, String value) {
        BooleanManagedProperty _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private BooleanManagedProperty _copy() {
        BooleanManagedProperty _x = new BooleanManagedProperty();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.value = this.value;
        _x.canBeChanged = this.canBeChanged;
        _x.managedPropertyLogicalName = this.managedPropertyLogicalName;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("BooleanManagedProperty[");
        b.append("Value=");
        b.append(this.value);
        b.append(", ");
        b.append("CanBeChanged=");
        b.append(this.canBeChanged);
        b.append(", ");
        b.append("ManagedPropertyLogicalName=");
        b.append(this.managedPropertyLogicalName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Boolean value;
        private Boolean canBeChanged;
        private String managedPropertyLogicalName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder value(Boolean value) {
            this.value = value;
            this.changedFields = this.changedFields.add("Value");
            return this;
        }

        public Builder canBeChanged(Boolean canBeChanged) {
            this.canBeChanged = canBeChanged;
            this.changedFields = this.changedFields.add("CanBeChanged");
            return this;
        }

        public Builder managedPropertyLogicalName(String managedPropertyLogicalName) {
            this.managedPropertyLogicalName = managedPropertyLogicalName;
            this.changedFields = this.changedFields.add("ManagedPropertyLogicalName");
            return this;
        }

        public BooleanManagedProperty build() {
            BooleanManagedProperty _x = new BooleanManagedProperty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.BooleanManagedProperty";
            _x.value = this.value;
            _x.canBeChanged = this.canBeChanged;
            _x.managedPropertyLogicalName = this.managedPropertyLogicalName;
            return _x;
        }
    }
}

