/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.DependentAttributeMetadataCollection;
import microsoft.dynamics.crm.complex.DependentRelationshipCollection;

@JsonPropertyOrder(value={"@odata.type", "EntityId", "LogicalName", "LogicalCollectionName", "ObjectTypeCode", "DisplayName", "PrimaryNameAttribute", "PrimaryIdAttribute", "Attributes", "Relationships"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class DependentEntityMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="EntityId")
    protected String entityId;
    @JsonProperty(value="LogicalName")
    protected String logicalName;
    @JsonProperty(value="LogicalCollectionName")
    protected String logicalCollectionName;
    @JsonProperty(value="ObjectTypeCode")
    protected Integer objectTypeCode;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="PrimaryNameAttribute")
    protected String primaryNameAttribute;
    @JsonProperty(value="PrimaryIdAttribute")
    protected String primaryIdAttribute;
    @JsonProperty(value="Attributes")
    protected DependentAttributeMetadataCollection attributes;
    @JsonProperty(value="Relationships")
    protected DependentRelationshipCollection relationships;

    protected DependentEntityMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.DependentEntityMetadata";
    }

    @Property(name="EntityId")
    @JsonIgnore
    public Optional<String> getEntityId() {
        return Optional.ofNullable(this.entityId);
    }

    public DependentEntityMetadata withEntityId(String entityId) {
        Checks.checkIsAscii((String)entityId);
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.entityId = entityId;
        return _x;
    }

    @Property(name="LogicalName")
    @JsonIgnore
    public Optional<String> getLogicalName() {
        return Optional.ofNullable(this.logicalName);
    }

    public DependentEntityMetadata withLogicalName(String logicalName) {
        Checks.checkIsAscii((String)logicalName);
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.logicalName = logicalName;
        return _x;
    }

    @Property(name="LogicalCollectionName")
    @JsonIgnore
    public Optional<String> getLogicalCollectionName() {
        return Optional.ofNullable(this.logicalCollectionName);
    }

    public DependentEntityMetadata withLogicalCollectionName(String logicalCollectionName) {
        Checks.checkIsAscii((String)logicalCollectionName);
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.logicalCollectionName = logicalCollectionName;
        return _x;
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(this.objectTypeCode);
    }

    public DependentEntityMetadata withObjectTypeCode(Integer objectTypeCode) {
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public DependentEntityMetadata withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="PrimaryNameAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryNameAttribute() {
        return Optional.ofNullable(this.primaryNameAttribute);
    }

    public DependentEntityMetadata withPrimaryNameAttribute(String primaryNameAttribute) {
        Checks.checkIsAscii((String)primaryNameAttribute);
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.primaryNameAttribute = primaryNameAttribute;
        return _x;
    }

    @Property(name="PrimaryIdAttribute")
    @JsonIgnore
    public Optional<String> getPrimaryIdAttribute() {
        return Optional.ofNullable(this.primaryIdAttribute);
    }

    public DependentEntityMetadata withPrimaryIdAttribute(String primaryIdAttribute) {
        Checks.checkIsAscii((String)primaryIdAttribute);
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.primaryIdAttribute = primaryIdAttribute;
        return _x;
    }

    @Property(name="Attributes")
    @JsonIgnore
    public Optional<DependentAttributeMetadataCollection> getAttributes() {
        return Optional.ofNullable(this.attributes);
    }

    public DependentEntityMetadata withAttributes(DependentAttributeMetadataCollection attributes) {
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.attributes = attributes;
        return _x;
    }

    @Property(name="Relationships")
    @JsonIgnore
    public Optional<DependentRelationshipCollection> getRelationships() {
        return Optional.ofNullable(this.relationships);
    }

    public DependentEntityMetadata withRelationships(DependentRelationshipCollection relationships) {
        DependentEntityMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.DependentEntityMetadata");
        _x.relationships = relationships;
        return _x;
    }

    public DependentEntityMetadata withUnmappedField(String name, String value) {
        DependentEntityMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private DependentEntityMetadata _copy() {
        DependentEntityMetadata _x = new DependentEntityMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.entityId = this.entityId;
        _x.logicalName = this.logicalName;
        _x.logicalCollectionName = this.logicalCollectionName;
        _x.objectTypeCode = this.objectTypeCode;
        _x.displayName = this.displayName;
        _x.primaryNameAttribute = this.primaryNameAttribute;
        _x.primaryIdAttribute = this.primaryIdAttribute;
        _x.attributes = this.attributes;
        _x.relationships = this.relationships;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("DependentEntityMetadata[");
        b.append("EntityId=");
        b.append(this.entityId);
        b.append(", ");
        b.append("LogicalName=");
        b.append(this.logicalName);
        b.append(", ");
        b.append("LogicalCollectionName=");
        b.append(this.logicalCollectionName);
        b.append(", ");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("PrimaryNameAttribute=");
        b.append(this.primaryNameAttribute);
        b.append(", ");
        b.append("PrimaryIdAttribute=");
        b.append(this.primaryIdAttribute);
        b.append(", ");
        b.append("Attributes=");
        b.append(this.attributes);
        b.append(", ");
        b.append("Relationships=");
        b.append(this.relationships);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String entityId;
        private String logicalName;
        private String logicalCollectionName;
        private Integer objectTypeCode;
        private String displayName;
        private String primaryNameAttribute;
        private String primaryIdAttribute;
        private DependentAttributeMetadataCollection attributes;
        private DependentRelationshipCollection relationships;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder entityId(String entityId) {
            this.entityId = entityId;
            this.changedFields = this.changedFields.add("EntityId");
            return this;
        }

        public Builder logicalName(String logicalName) {
            this.logicalName = logicalName;
            this.changedFields = this.changedFields.add("LogicalName");
            return this;
        }

        public Builder logicalCollectionName(String logicalCollectionName) {
            this.logicalCollectionName = logicalCollectionName;
            this.changedFields = this.changedFields.add("LogicalCollectionName");
            return this;
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = this.changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder primaryNameAttribute(String primaryNameAttribute) {
            this.primaryNameAttribute = primaryNameAttribute;
            this.changedFields = this.changedFields.add("PrimaryNameAttribute");
            return this;
        }

        public Builder primaryIdAttribute(String primaryIdAttribute) {
            this.primaryIdAttribute = primaryIdAttribute;
            this.changedFields = this.changedFields.add("PrimaryIdAttribute");
            return this;
        }

        public Builder attributes(DependentAttributeMetadataCollection attributes) {
            this.attributes = attributes;
            this.changedFields = this.changedFields.add("Attributes");
            return this;
        }

        public Builder relationships(DependentRelationshipCollection relationships) {
            this.relationships = relationships;
            this.changedFields = this.changedFields.add("Relationships");
            return this;
        }

        public DependentEntityMetadata build() {
            DependentEntityMetadata _x = new DependentEntityMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.DependentEntityMetadata";
            _x.entityId = this.entityId;
            _x.logicalName = this.logicalName;
            _x.logicalCollectionName = this.logicalCollectionName;
            _x.objectTypeCode = this.objectTypeCode;
            _x.displayName = this.displayName;
            _x.primaryNameAttribute = this.primaryNameAttribute;
            _x.primaryIdAttribute = this.primaryIdAttribute;
            _x.attributes = this.attributes;
            _x.relationships = this.relationships;
            return _x;
        }
    }
}

