/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "ObjectTypeCode", "FilePointers"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class EntityFilePointersRequest
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ObjectTypeCode")
    protected Integer objectTypeCode;
    @JsonProperty(value="FilePointers")
    protected List<String> filePointers;
    @JsonProperty(value="FilePointers@nextLink")
    protected String filePointersNextLink;

    protected EntityFilePointersRequest() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.EntityFilePointersRequest";
    }

    @Property(name="ObjectTypeCode")
    @JsonIgnore
    public Optional<Integer> getObjectTypeCode() {
        return Optional.ofNullable(this.objectTypeCode);
    }

    public EntityFilePointersRequest withObjectTypeCode(Integer objectTypeCode) {
        EntityFilePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.EntityFilePointersRequest");
        _x.objectTypeCode = objectTypeCode;
        return _x;
    }

    @Property(name="FilePointers")
    @JsonIgnore
    public CollectionPage<String> getFilePointers() {
        return new CollectionPage(this.contextPath, String.class, this.filePointers, Optional.ofNullable(this.filePointersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="FilePointers")
    @JsonIgnore
    public CollectionPage<String> getFilePointers(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, String.class, this.filePointers, Optional.ofNullable(this.filePointersNextLink), Collections.emptyList(), options);
    }

    public EntityFilePointersRequest withUnmappedField(String name, String value) {
        EntityFilePointersRequest _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private EntityFilePointersRequest _copy() {
        EntityFilePointersRequest _x = new EntityFilePointersRequest();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.objectTypeCode = this.objectTypeCode;
        _x.filePointers = this.filePointers;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("EntityFilePointersRequest[");
        b.append("ObjectTypeCode=");
        b.append(this.objectTypeCode);
        b.append(", ");
        b.append("FilePointers=");
        b.append(this.filePointers);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer objectTypeCode;
        private List<String> filePointers;
        private String filePointersNextLink;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder objectTypeCode(Integer objectTypeCode) {
            this.objectTypeCode = objectTypeCode;
            this.changedFields = this.changedFields.add("ObjectTypeCode");
            return this;
        }

        public Builder filePointers(List<String> filePointers) {
            this.filePointers = filePointers;
            this.changedFields = this.changedFields.add("FilePointers");
            return this;
        }

        public Builder filePointers(String ... filePointers) {
            return this.filePointers(Arrays.asList(filePointers));
        }

        public Builder filePointersNextLink(String filePointersNextLink) {
            this.filePointersNextLink = filePointersNextLink;
            this.changedFields = this.changedFields.add("FilePointers");
            return this;
        }

        public EntityFilePointersRequest build() {
            EntityFilePointersRequest _x = new EntityFilePointersRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.EntityFilePointersRequest";
            _x.objectTypeCode = this.objectTypeCode;
            _x.filePointers = this.filePointers;
            _x.filePointersNextLink = this.filePointersNextLink;
            return _x;
        }
    }
}

