/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "FileName", "FileSizeInBytes", "MimeType", "SasUrl"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FileSasUrlResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="FileName")
    protected String fileName;
    @JsonProperty(value="FileSizeInBytes")
    protected Long fileSizeInBytes;
    @JsonProperty(value="MimeType")
    protected String mimeType;
    @JsonProperty(value="SasUrl")
    protected String sasUrl;

    protected FileSasUrlResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FileSasUrlResponse";
    }

    @Property(name="FileName")
    @JsonIgnore
    public Optional<String> getFileName() {
        return Optional.ofNullable(this.fileName);
    }

    public FileSasUrlResponse withFileName(String fileName) {
        Checks.checkIsAscii((String)fileName);
        FileSasUrlResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.fileName = fileName;
        return _x;
    }

    @Property(name="FileSizeInBytes")
    @JsonIgnore
    public Optional<Long> getFileSizeInBytes() {
        return Optional.ofNullable(this.fileSizeInBytes);
    }

    public FileSasUrlResponse withFileSizeInBytes(Long fileSizeInBytes) {
        FileSasUrlResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.fileSizeInBytes = fileSizeInBytes;
        return _x;
    }

    @Property(name="MimeType")
    @JsonIgnore
    public Optional<String> getMimeType() {
        return Optional.ofNullable(this.mimeType);
    }

    public FileSasUrlResponse withMimeType(String mimeType) {
        Checks.checkIsAscii((String)mimeType);
        FileSasUrlResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.mimeType = mimeType;
        return _x;
    }

    @Property(name="SasUrl")
    @JsonIgnore
    public Optional<String> getSasUrl() {
        return Optional.ofNullable(this.sasUrl);
    }

    public FileSasUrlResponse withSasUrl(String sasUrl) {
        Checks.checkIsAscii((String)sasUrl);
        FileSasUrlResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FileSasUrlResponse");
        _x.sasUrl = sasUrl;
        return _x;
    }

    public FileSasUrlResponse withUnmappedField(String name, String value) {
        FileSasUrlResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private FileSasUrlResponse _copy() {
        FileSasUrlResponse _x = new FileSasUrlResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.fileName = this.fileName;
        _x.fileSizeInBytes = this.fileSizeInBytes;
        _x.mimeType = this.mimeType;
        _x.sasUrl = this.sasUrl;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FileSasUrlResponse[");
        b.append("FileName=");
        b.append(this.fileName);
        b.append(", ");
        b.append("FileSizeInBytes=");
        b.append(this.fileSizeInBytes);
        b.append(", ");
        b.append("MimeType=");
        b.append(this.mimeType);
        b.append(", ");
        b.append("SasUrl=");
        b.append(this.sasUrl);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String fileName;
        private Long fileSizeInBytes;
        private String mimeType;
        private String sasUrl;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder fileName(String fileName) {
            this.fileName = fileName;
            this.changedFields = this.changedFields.add("FileName");
            return this;
        }

        public Builder fileSizeInBytes(Long fileSizeInBytes) {
            this.fileSizeInBytes = fileSizeInBytes;
            this.changedFields = this.changedFields.add("FileSizeInBytes");
            return this;
        }

        public Builder mimeType(String mimeType) {
            this.mimeType = mimeType;
            this.changedFields = this.changedFields.add("MimeType");
            return this;
        }

        public Builder sasUrl(String sasUrl) {
            this.sasUrl = sasUrl;
            this.changedFields = this.changedFields.add("SasUrl");
            return this;
        }

        public FileSasUrlResponse build() {
            FileSasUrlResponse _x = new FileSasUrlResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.FileSasUrlResponse";
            _x.fileName = this.fileName;
            _x.fileSizeInBytes = this.fileSizeInBytes;
            _x.mimeType = this.mimeType;
            _x.sasUrl = this.sasUrl;
            return _x;
        }
    }
}

