/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.LookupMetadata;

@JsonPropertyOrder(value={"@odata.type", "Metadata", "EntityLogicalName", "TotalRecordCount", "PagingCookie"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class LookupEntityResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Metadata")
    protected LookupMetadata metadata;
    @JsonProperty(value="EntityLogicalName")
    protected String entityLogicalName;
    @JsonProperty(value="TotalRecordCount")
    protected Integer totalRecordCount;
    @JsonProperty(value="PagingCookie")
    protected String pagingCookie;

    protected LookupEntityResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.LookupEntityResponse";
    }

    @Property(name="Metadata")
    @JsonIgnore
    public Optional<LookupMetadata> getMetadata() {
        return Optional.ofNullable(this.metadata);
    }

    public LookupEntityResponse withMetadata(LookupMetadata metadata) {
        LookupEntityResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.metadata = metadata;
        return _x;
    }

    @Property(name="EntityLogicalName")
    @JsonIgnore
    public Optional<String> getEntityLogicalName() {
        return Optional.ofNullable(this.entityLogicalName);
    }

    public LookupEntityResponse withEntityLogicalName(String entityLogicalName) {
        Checks.checkIsAscii((String)entityLogicalName);
        LookupEntityResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.entityLogicalName = entityLogicalName;
        return _x;
    }

    @Property(name="TotalRecordCount")
    @JsonIgnore
    public Optional<Integer> getTotalRecordCount() {
        return Optional.ofNullable(this.totalRecordCount);
    }

    public LookupEntityResponse withTotalRecordCount(Integer totalRecordCount) {
        LookupEntityResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.totalRecordCount = totalRecordCount;
        return _x;
    }

    @Property(name="PagingCookie")
    @JsonIgnore
    public Optional<String> getPagingCookie() {
        return Optional.ofNullable(this.pagingCookie);
    }

    public LookupEntityResponse withPagingCookie(String pagingCookie) {
        Checks.checkIsAscii((String)pagingCookie);
        LookupEntityResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.LookupEntityResponse");
        _x.pagingCookie = pagingCookie;
        return _x;
    }

    public LookupEntityResponse withUnmappedField(String name, String value) {
        LookupEntityResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private LookupEntityResponse _copy() {
        LookupEntityResponse _x = new LookupEntityResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.metadata = this.metadata;
        _x.entityLogicalName = this.entityLogicalName;
        _x.totalRecordCount = this.totalRecordCount;
        _x.pagingCookie = this.pagingCookie;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("LookupEntityResponse[");
        b.append("Metadata=");
        b.append(this.metadata);
        b.append(", ");
        b.append("EntityLogicalName=");
        b.append(this.entityLogicalName);
        b.append(", ");
        b.append("TotalRecordCount=");
        b.append(this.totalRecordCount);
        b.append(", ");
        b.append("PagingCookie=");
        b.append(this.pagingCookie);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private LookupMetadata metadata;
        private String entityLogicalName;
        private Integer totalRecordCount;
        private String pagingCookie;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder metadata(LookupMetadata metadata) {
            this.metadata = metadata;
            this.changedFields = this.changedFields.add("Metadata");
            return this;
        }

        public Builder entityLogicalName(String entityLogicalName) {
            this.entityLogicalName = entityLogicalName;
            this.changedFields = this.changedFields.add("EntityLogicalName");
            return this;
        }

        public Builder totalRecordCount(Integer totalRecordCount) {
            this.totalRecordCount = totalRecordCount;
            this.changedFields = this.changedFields.add("TotalRecordCount");
            return this;
        }

        public Builder pagingCookie(String pagingCookie) {
            this.pagingCookie = pagingCookie;
            this.changedFields = this.changedFields.add("PagingCookie");
            return this;
        }

        public LookupEntityResponse build() {
            LookupEntityResponse _x = new LookupEntityResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.LookupEntityResponse";
            _x.metadata = this.metadata;
            _x.entityLogicalName = this.entityLogicalName;
            _x.totalRecordCount = this.totalRecordCount;
            _x.pagingCookie = this.pagingCookie;
            return _x;
        }
    }
}

