/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "ResourceSpecId", "ObjectiveExpression"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ObjectiveRelation
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ResourceSpecId")
    protected String resourceSpecId;
    @JsonProperty(value="ObjectiveExpression")
    protected String objectiveExpression;

    protected ObjectiveRelation() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ObjectiveRelation";
    }

    @Property(name="ResourceSpecId")
    @JsonIgnore
    public Optional<String> getResourceSpecId() {
        return Optional.ofNullable(this.resourceSpecId);
    }

    public ObjectiveRelation withResourceSpecId(String resourceSpecId) {
        ObjectiveRelation _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ObjectiveRelation");
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    @Property(name="ObjectiveExpression")
    @JsonIgnore
    public Optional<String> getObjectiveExpression() {
        return Optional.ofNullable(this.objectiveExpression);
    }

    public ObjectiveRelation withObjectiveExpression(String objectiveExpression) {
        Checks.checkIsAscii((String)objectiveExpression);
        ObjectiveRelation _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ObjectiveRelation");
        _x.objectiveExpression = objectiveExpression;
        return _x;
    }

    public ObjectiveRelation withUnmappedField(String name, String value) {
        ObjectiveRelation _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ObjectiveRelation _copy() {
        ObjectiveRelation _x = new ObjectiveRelation();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.resourceSpecId = this.resourceSpecId;
        _x.objectiveExpression = this.objectiveExpression;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ObjectiveRelation[");
        b.append("ResourceSpecId=");
        b.append(this.resourceSpecId);
        b.append(", ");
        b.append("ObjectiveExpression=");
        b.append(this.objectiveExpression);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String resourceSpecId;
        private String objectiveExpression;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder resourceSpecId(String resourceSpecId) {
            this.resourceSpecId = resourceSpecId;
            this.changedFields = this.changedFields.add("ResourceSpecId");
            return this;
        }

        public Builder objectiveExpression(String objectiveExpression) {
            this.objectiveExpression = objectiveExpression;
            this.changedFields = this.changedFields.add("ObjectiveExpression");
            return this;
        }

        public ObjectiveRelation build() {
            ObjectiveRelation _x = new ObjectiveRelation();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ObjectiveRelation";
            _x.resourceSpecId = this.resourceSpecId;
            _x.objectiveExpression = this.objectiveExpression;
            return _x;
        }
    }
}

