/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "ResourceId", "ResourceSpecId", "DisplayName", "EntityName", "EffortRequired"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ProposalParty
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ResourceId")
    protected String resourceId;
    @JsonProperty(value="ResourceSpecId")
    protected String resourceSpecId;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="EntityName")
    protected String entityName;
    @JsonProperty(value="EffortRequired")
    protected Double effortRequired;

    protected ProposalParty() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ProposalParty";
    }

    @Property(name="ResourceId")
    @JsonIgnore
    public Optional<String> getResourceId() {
        return Optional.ofNullable(this.resourceId);
    }

    public ProposalParty withResourceId(String resourceId) {
        ProposalParty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ProposalParty");
        _x.resourceId = resourceId;
        return _x;
    }

    @Property(name="ResourceSpecId")
    @JsonIgnore
    public Optional<String> getResourceSpecId() {
        return Optional.ofNullable(this.resourceSpecId);
    }

    public ProposalParty withResourceSpecId(String resourceSpecId) {
        ProposalParty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ProposalParty");
        _x.resourceSpecId = resourceSpecId;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public ProposalParty withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        ProposalParty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ProposalParty");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="EntityName")
    @JsonIgnore
    public Optional<String> getEntityName() {
        return Optional.ofNullable(this.entityName);
    }

    public ProposalParty withEntityName(String entityName) {
        Checks.checkIsAscii((String)entityName);
        ProposalParty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ProposalParty");
        _x.entityName = entityName;
        return _x;
    }

    @Property(name="EffortRequired")
    @JsonIgnore
    public Optional<Double> getEffortRequired() {
        return Optional.ofNullable(this.effortRequired);
    }

    public ProposalParty withEffortRequired(Double effortRequired) {
        ProposalParty _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ProposalParty");
        _x.effortRequired = effortRequired;
        return _x;
    }

    public ProposalParty withUnmappedField(String name, String value) {
        ProposalParty _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ProposalParty _copy() {
        ProposalParty _x = new ProposalParty();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.resourceId = this.resourceId;
        _x.resourceSpecId = this.resourceSpecId;
        _x.displayName = this.displayName;
        _x.entityName = this.entityName;
        _x.effortRequired = this.effortRequired;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ProposalParty[");
        b.append("ResourceId=");
        b.append(this.resourceId);
        b.append(", ");
        b.append("ResourceSpecId=");
        b.append(this.resourceSpecId);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("EntityName=");
        b.append(this.entityName);
        b.append(", ");
        b.append("EffortRequired=");
        b.append(this.effortRequired);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String resourceId;
        private String resourceSpecId;
        private String displayName;
        private String entityName;
        private Double effortRequired;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            this.changedFields = this.changedFields.add("ResourceId");
            return this;
        }

        public Builder resourceSpecId(String resourceSpecId) {
            this.resourceSpecId = resourceSpecId;
            this.changedFields = this.changedFields.add("ResourceSpecId");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder entityName(String entityName) {
            this.entityName = entityName;
            this.changedFields = this.changedFields.add("EntityName");
            return this;
        }

        public Builder effortRequired(Double effortRequired) {
            this.effortRequired = effortRequired;
            this.changedFields = this.changedFields.add("EffortRequired");
            return this;
        }

        public ProposalParty build() {
            ProposalParty _x = new ProposalParty();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ProposalParty";
            _x.resourceId = this.resourceId;
            _x.resourceSpecId = this.resourceSpecId;
            _x.displayName = this.displayName;
            _x.entityName = this.entityName;
            _x.effortRequired = this.effortRequired;
            return _x;
        }
    }
}

