/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "ReferencingAttributeName", "ReferencedAttributeName"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class RelationshipAttribute
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ReferencingAttributeName")
    protected String referencingAttributeName;
    @JsonProperty(value="ReferencedAttributeName")
    protected String referencedAttributeName;

    protected RelationshipAttribute() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.RelationshipAttribute";
    }

    @Property(name="ReferencingAttributeName")
    @JsonIgnore
    public Optional<String> getReferencingAttributeName() {
        return Optional.ofNullable(this.referencingAttributeName);
    }

    public RelationshipAttribute withReferencingAttributeName(String referencingAttributeName) {
        Checks.checkIsAscii((String)referencingAttributeName);
        RelationshipAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipAttribute");
        _x.referencingAttributeName = referencingAttributeName;
        return _x;
    }

    @Property(name="ReferencedAttributeName")
    @JsonIgnore
    public Optional<String> getReferencedAttributeName() {
        return Optional.ofNullable(this.referencedAttributeName);
    }

    public RelationshipAttribute withReferencedAttributeName(String referencedAttributeName) {
        Checks.checkIsAscii((String)referencedAttributeName);
        RelationshipAttribute _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.RelationshipAttribute");
        _x.referencedAttributeName = referencedAttributeName;
        return _x;
    }

    public RelationshipAttribute withUnmappedField(String name, String value) {
        RelationshipAttribute _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private RelationshipAttribute _copy() {
        RelationshipAttribute _x = new RelationshipAttribute();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.referencingAttributeName = this.referencingAttributeName;
        _x.referencedAttributeName = this.referencedAttributeName;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("RelationshipAttribute[");
        b.append("ReferencingAttributeName=");
        b.append(this.referencingAttributeName);
        b.append(", ");
        b.append("ReferencedAttributeName=");
        b.append(this.referencedAttributeName);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String referencingAttributeName;
        private String referencedAttributeName;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder referencingAttributeName(String referencingAttributeName) {
            this.referencingAttributeName = referencingAttributeName;
            this.changedFields = this.changedFields.add("ReferencingAttributeName");
            return this;
        }

        public Builder referencedAttributeName(String referencedAttributeName) {
            this.referencedAttributeName = referencedAttributeName;
            this.changedFields = this.changedFields.add("ReferencedAttributeName");
            return this;
        }

        public RelationshipAttribute build() {
            RelationshipAttribute _x = new RelationshipAttribute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.RelationshipAttribute";
            _x.referencingAttributeName = this.referencingAttributeName;
            _x.referencedAttributeName = this.referencedAttributeName;
            return _x;
        }
    }
}

