/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;

@JsonPropertyOrder(value={"@odata.type", "Prefix", "StoragePointer", "FilePointer", "FileSize", "Otc", "TargetObjectId", "SetBodyToNull"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class UpdatePointersRequest
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Prefix")
    protected String prefix;
    @JsonProperty(value="StoragePointer")
    protected Integer storagePointer;
    @JsonProperty(value="FilePointer")
    protected String filePointer;
    @JsonProperty(value="FileSize")
    protected Long fileSize;
    @JsonProperty(value="Otc")
    protected Integer otc;
    @JsonProperty(value="TargetObjectId")
    protected String targetObjectId;
    @JsonProperty(value="SetBodyToNull")
    protected Boolean setBodyToNull;

    protected UpdatePointersRequest() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.UpdatePointersRequest";
    }

    @Property(name="Prefix")
    @JsonIgnore
    public Optional<String> getPrefix() {
        return Optional.ofNullable(this.prefix);
    }

    public UpdatePointersRequest withPrefix(String prefix) {
        Checks.checkIsAscii((String)prefix);
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.prefix = prefix;
        return _x;
    }

    @Property(name="StoragePointer")
    @JsonIgnore
    public Optional<Integer> getStoragePointer() {
        return Optional.ofNullable(this.storagePointer);
    }

    public UpdatePointersRequest withStoragePointer(Integer storagePointer) {
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.storagePointer = storagePointer;
        return _x;
    }

    @Property(name="FilePointer")
    @JsonIgnore
    public Optional<String> getFilePointer() {
        return Optional.ofNullable(this.filePointer);
    }

    public UpdatePointersRequest withFilePointer(String filePointer) {
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.filePointer = filePointer;
        return _x;
    }

    @Property(name="FileSize")
    @JsonIgnore
    public Optional<Long> getFileSize() {
        return Optional.ofNullable(this.fileSize);
    }

    public UpdatePointersRequest withFileSize(Long fileSize) {
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.fileSize = fileSize;
        return _x;
    }

    @Property(name="Otc")
    @JsonIgnore
    public Optional<Integer> getOtc() {
        return Optional.ofNullable(this.otc);
    }

    public UpdatePointersRequest withOtc(Integer otc) {
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.otc = otc;
        return _x;
    }

    @Property(name="TargetObjectId")
    @JsonIgnore
    public Optional<String> getTargetObjectId() {
        return Optional.ofNullable(this.targetObjectId);
    }

    public UpdatePointersRequest withTargetObjectId(String targetObjectId) {
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.targetObjectId = targetObjectId;
        return _x;
    }

    @Property(name="SetBodyToNull")
    @JsonIgnore
    public Optional<Boolean> getSetBodyToNull() {
        return Optional.ofNullable(this.setBodyToNull);
    }

    public UpdatePointersRequest withSetBodyToNull(Boolean setBodyToNull) {
        UpdatePointersRequest _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.UpdatePointersRequest");
        _x.setBodyToNull = setBodyToNull;
        return _x;
    }

    public UpdatePointersRequest withUnmappedField(String name, String value) {
        UpdatePointersRequest _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private UpdatePointersRequest _copy() {
        UpdatePointersRequest _x = new UpdatePointersRequest();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.prefix = this.prefix;
        _x.storagePointer = this.storagePointer;
        _x.filePointer = this.filePointer;
        _x.fileSize = this.fileSize;
        _x.otc = this.otc;
        _x.targetObjectId = this.targetObjectId;
        _x.setBodyToNull = this.setBodyToNull;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("UpdatePointersRequest[");
        b.append("Prefix=");
        b.append(this.prefix);
        b.append(", ");
        b.append("StoragePointer=");
        b.append(this.storagePointer);
        b.append(", ");
        b.append("FilePointer=");
        b.append(this.filePointer);
        b.append(", ");
        b.append("FileSize=");
        b.append(this.fileSize);
        b.append(", ");
        b.append("Otc=");
        b.append(this.otc);
        b.append(", ");
        b.append("TargetObjectId=");
        b.append(this.targetObjectId);
        b.append(", ");
        b.append("SetBodyToNull=");
        b.append(this.setBodyToNull);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String prefix;
        private Integer storagePointer;
        private String filePointer;
        private Long fileSize;
        private Integer otc;
        private String targetObjectId;
        private Boolean setBodyToNull;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder prefix(String prefix) {
            this.prefix = prefix;
            this.changedFields = this.changedFields.add("Prefix");
            return this;
        }

        public Builder storagePointer(Integer storagePointer) {
            this.storagePointer = storagePointer;
            this.changedFields = this.changedFields.add("StoragePointer");
            return this;
        }

        public Builder filePointer(String filePointer) {
            this.filePointer = filePointer;
            this.changedFields = this.changedFields.add("FilePointer");
            return this;
        }

        public Builder fileSize(Long fileSize) {
            this.fileSize = fileSize;
            this.changedFields = this.changedFields.add("FileSize");
            return this;
        }

        public Builder otc(Integer otc) {
            this.otc = otc;
            this.changedFields = this.changedFields.add("Otc");
            return this;
        }

        public Builder targetObjectId(String targetObjectId) {
            this.targetObjectId = targetObjectId;
            this.changedFields = this.changedFields.add("TargetObjectId");
            return this;
        }

        public Builder setBodyToNull(Boolean setBodyToNull) {
            this.setBodyToNull = setBodyToNull;
            this.changedFields = this.changedFields.add("SetBodyToNull");
            return this;
        }

        public UpdatePointersRequest build() {
            UpdatePointersRequest _x = new UpdatePointersRequest();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.UpdatePointersRequest";
            _x.prefix = this.prefix;
            _x.storagePointer = this.storagePointer;
            _x.filePointer = this.filePointer;
            _x.fileSize = this.fileSize;
            _x.otc = this.otc;
            _x.targetObjectId = this.targetObjectId;
            _x.setBodyToNull = this.setBodyToNull;
            return _x;
        }
    }
}

