/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.enums.XrmAggregateType;
import microsoft.dynamics.crm.enums.XrmDateTimeGrouping;

@JsonPropertyOrder(value={"@odata.type", "AttributeName", "AggregateType", "Alias", "HasGroupBy", "DateTimeGrouping"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class XrmAttributeExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="AttributeName")
    protected String attributeName;
    @JsonProperty(value="AggregateType")
    protected XrmAggregateType aggregateType;
    @JsonProperty(value="Alias")
    protected String alias;
    @JsonProperty(value="HasGroupBy")
    protected Boolean hasGroupBy;
    @JsonProperty(value="DateTimeGrouping")
    protected XrmDateTimeGrouping dateTimeGrouping;

    protected XrmAttributeExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.XrmAttributeExpression";
    }

    @Property(name="AttributeName")
    @JsonIgnore
    public Optional<String> getAttributeName() {
        return Optional.ofNullable(this.attributeName);
    }

    public XrmAttributeExpression withAttributeName(String attributeName) {
        Checks.checkIsAscii((String)attributeName);
        XrmAttributeExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.attributeName = attributeName;
        return _x;
    }

    @Property(name="AggregateType")
    @JsonIgnore
    public Optional<XrmAggregateType> getAggregateType() {
        return Optional.ofNullable(this.aggregateType);
    }

    public XrmAttributeExpression withAggregateType(XrmAggregateType aggregateType) {
        XrmAttributeExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.aggregateType = aggregateType;
        return _x;
    }

    @Property(name="Alias")
    @JsonIgnore
    public Optional<String> getAlias() {
        return Optional.ofNullable(this.alias);
    }

    public XrmAttributeExpression withAlias(String alias) {
        Checks.checkIsAscii((String)alias);
        XrmAttributeExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.alias = alias;
        return _x;
    }

    @Property(name="HasGroupBy")
    @JsonIgnore
    public Optional<Boolean> getHasGroupBy() {
        return Optional.ofNullable(this.hasGroupBy);
    }

    public XrmAttributeExpression withHasGroupBy(Boolean hasGroupBy) {
        XrmAttributeExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.hasGroupBy = hasGroupBy;
        return _x;
    }

    @Property(name="DateTimeGrouping")
    @JsonIgnore
    public Optional<XrmDateTimeGrouping> getDateTimeGrouping() {
        return Optional.ofNullable(this.dateTimeGrouping);
    }

    public XrmAttributeExpression withDateTimeGrouping(XrmDateTimeGrouping dateTimeGrouping) {
        XrmAttributeExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.XrmAttributeExpression");
        _x.dateTimeGrouping = dateTimeGrouping;
        return _x;
    }

    public XrmAttributeExpression withUnmappedField(String name, String value) {
        XrmAttributeExpression _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private XrmAttributeExpression _copy() {
        XrmAttributeExpression _x = new XrmAttributeExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.attributeName = this.attributeName;
        _x.aggregateType = this.aggregateType;
        _x.alias = this.alias;
        _x.hasGroupBy = this.hasGroupBy;
        _x.dateTimeGrouping = this.dateTimeGrouping;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("XrmAttributeExpression[");
        b.append("AttributeName=");
        b.append(this.attributeName);
        b.append(", ");
        b.append("AggregateType=");
        b.append((Object)this.aggregateType);
        b.append(", ");
        b.append("Alias=");
        b.append(this.alias);
        b.append(", ");
        b.append("HasGroupBy=");
        b.append(this.hasGroupBy);
        b.append(", ");
        b.append("DateTimeGrouping=");
        b.append((Object)this.dateTimeGrouping);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private String attributeName;
        private XrmAggregateType aggregateType;
        private String alias;
        private Boolean hasGroupBy;
        private XrmDateTimeGrouping dateTimeGrouping;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
        }

        public Builder attributeName(String attributeName) {
            this.attributeName = attributeName;
            this.changedFields = this.changedFields.add("AttributeName");
            return this;
        }

        public Builder aggregateType(XrmAggregateType aggregateType) {
            this.aggregateType = aggregateType;
            this.changedFields = this.changedFields.add("AggregateType");
            return this;
        }

        public Builder alias(String alias) {
            this.alias = alias;
            this.changedFields = this.changedFields.add("Alias");
            return this;
        }

        public Builder hasGroupBy(Boolean hasGroupBy) {
            this.hasGroupBy = hasGroupBy;
            this.changedFields = this.changedFields.add("HasGroupBy");
            return this;
        }

        public Builder dateTimeGrouping(XrmDateTimeGrouping dateTimeGrouping) {
            this.dateTimeGrouping = dateTimeGrouping;
            this.changedFields = this.changedFields.add("DateTimeGrouping");
            return this;
        }

        public XrmAttributeExpression build() {
            XrmAttributeExpression _x = new XrmAttributeExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.XrmAttributeExpression";
            _x.attributeName = this.attributeName;
            _x.aggregateType = this.aggregateType;
            _x.alias = this.alias;
            _x.hasGroupBy = this.hasGroupBy;
            _x.dateTimeGrouping = this.dateTimeGrouping;
            return _x;
        }
    }
}

