/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.BooleanManagedProperty;
import microsoft.dynamics.crm.complex.Label;
import microsoft.dynamics.crm.complex.OptionMetadata;
import microsoft.dynamics.crm.enums.OptionSetType;

@JsonPropertyOrder(value={"@odata.type", "Options", "ParentOptionSetName", "Description", "DisplayName", "IsCustomOptionSet", "IsGlobal", "IsManaged", "IsCustomizable", "Name", "ExternalTypeName", "OptionSetType", "IntroducedVersion", "MetadataId", "HasChanged"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ComplexOptionSetMetadata
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Options")
    protected List<OptionMetadata> options;
    @JsonProperty(value="Options@nextLink")
    protected String optionsNextLink;
    @JsonProperty(value="ParentOptionSetName")
    protected String parentOptionSetName;
    @JsonProperty(value="Description")
    protected Label description;
    @JsonProperty(value="DisplayName")
    protected Label displayName;
    @JsonProperty(value="IsCustomOptionSet")
    protected Boolean isCustomOptionSet;
    @JsonProperty(value="IsGlobal")
    protected Boolean isGlobal;
    @JsonProperty(value="IsManaged")
    protected Boolean isManaged;
    @JsonProperty(value="IsCustomizable")
    protected BooleanManagedProperty isCustomizable;
    @JsonProperty(value="Name")
    protected String name;
    @JsonProperty(value="ExternalTypeName")
    protected String externalTypeName;
    @JsonProperty(value="OptionSetType")
    protected OptionSetType optionSetType;
    @JsonProperty(value="IntroducedVersion")
    protected String introducedVersion;
    @JsonProperty(value="MetadataId")
    protected String metadataId;
    @JsonProperty(value="HasChanged")
    protected Boolean hasChanged;

    protected ComplexOptionSetMetadata() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata";
    }

    @Property(name="Options")
    @JsonIgnore
    public CollectionPage<OptionMetadata> getOptions() {
        return new CollectionPage(this.contextPath, OptionMetadata.class, this.options, Optional.ofNullable(this.optionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Options")
    @JsonIgnore
    public CollectionPage<OptionMetadata> getOptions(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, OptionMetadata.class, this.options, Optional.ofNullable(this.optionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="ParentOptionSetName")
    @JsonIgnore
    public Optional<String> getParentOptionSetName() {
        return Optional.ofNullable(this.parentOptionSetName);
    }

    public ComplexOptionSetMetadata withParentOptionSetName(String parentOptionSetName) {
        Checks.checkIsAscii((String)parentOptionSetName);
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.parentOptionSetName = parentOptionSetName;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<Label> getDescription() {
        return Optional.ofNullable(this.description);
    }

    public ComplexOptionSetMetadata withDescription(Label description) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.description = description;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<Label> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public ComplexOptionSetMetadata withDisplayName(Label displayName) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="IsCustomOptionSet")
    @JsonIgnore
    public Optional<Boolean> getIsCustomOptionSet() {
        return Optional.ofNullable(this.isCustomOptionSet);
    }

    public ComplexOptionSetMetadata withIsCustomOptionSet(Boolean isCustomOptionSet) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isCustomOptionSet = isCustomOptionSet;
        return _x;
    }

    @Property(name="IsGlobal")
    @JsonIgnore
    public Optional<Boolean> getIsGlobal() {
        return Optional.ofNullable(this.isGlobal);
    }

    public ComplexOptionSetMetadata withIsGlobal(Boolean isGlobal) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isGlobal = isGlobal;
        return _x;
    }

    @Property(name="IsManaged")
    @JsonIgnore
    public Optional<Boolean> getIsManaged() {
        return Optional.ofNullable(this.isManaged);
    }

    public ComplexOptionSetMetadata withIsManaged(Boolean isManaged) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isManaged = isManaged;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<BooleanManagedProperty> getIsCustomizable() {
        return Optional.ofNullable(this.isCustomizable);
    }

    public ComplexOptionSetMetadata withIsCustomizable(BooleanManagedProperty isCustomizable) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public ComplexOptionSetMetadata withName(String name) {
        Checks.checkIsAscii((String)name);
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.name = name;
        return _x;
    }

    @Property(name="ExternalTypeName")
    @JsonIgnore
    public Optional<String> getExternalTypeName() {
        return Optional.ofNullable(this.externalTypeName);
    }

    public ComplexOptionSetMetadata withExternalTypeName(String externalTypeName) {
        Checks.checkIsAscii((String)externalTypeName);
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.externalTypeName = externalTypeName;
        return _x;
    }

    @Property(name="OptionSetType")
    @JsonIgnore
    public Optional<OptionSetType> getOptionSetType() {
        return Optional.ofNullable(this.optionSetType);
    }

    public ComplexOptionSetMetadata withOptionSetType(OptionSetType optionSetType) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.optionSetType = optionSetType;
        return _x;
    }

    @Property(name="IntroducedVersion")
    @JsonIgnore
    public Optional<String> getIntroducedVersion() {
        return Optional.ofNullable(this.introducedVersion);
    }

    public ComplexOptionSetMetadata withIntroducedVersion(String introducedVersion) {
        Checks.checkIsAscii((String)introducedVersion);
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.introducedVersion = introducedVersion;
        return _x;
    }

    @Property(name="MetadataId")
    @JsonIgnore
    public Optional<String> getMetadataId() {
        return Optional.ofNullable(this.metadataId);
    }

    public ComplexOptionSetMetadata withMetadataId(String metadataId) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.metadataId = metadataId;
        return _x;
    }

    @Property(name="HasChanged")
    @JsonIgnore
    public Optional<Boolean> getHasChanged() {
        return Optional.ofNullable(this.hasChanged);
    }

    public ComplexOptionSetMetadata withHasChanged(Boolean hasChanged) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ComplexOptionSetMetadata");
        _x.hasChanged = hasChanged;
        return _x;
    }

    public ComplexOptionSetMetadata withUnmappedField(String name, String value) {
        ComplexOptionSetMetadata _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ComplexOptionSetMetadata _copy() {
        ComplexOptionSetMetadata _x = new ComplexOptionSetMetadata();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.options = this.options;
        _x.parentOptionSetName = this.parentOptionSetName;
        _x.description = this.description;
        _x.displayName = this.displayName;
        _x.isCustomOptionSet = this.isCustomOptionSet;
        _x.isGlobal = this.isGlobal;
        _x.isManaged = this.isManaged;
        _x.isCustomizable = this.isCustomizable;
        _x.name = this.name;
        _x.externalTypeName = this.externalTypeName;
        _x.optionSetType = this.optionSetType;
        _x.introducedVersion = this.introducedVersion;
        _x.metadataId = this.metadataId;
        _x.hasChanged = this.hasChanged;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ComplexOptionSetMetadata[");
        b.append("Options=");
        b.append(this.options);
        b.append(", ");
        b.append("ParentOptionSetName=");
        b.append(this.parentOptionSetName);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("IsCustomOptionSet=");
        b.append(this.isCustomOptionSet);
        b.append(", ");
        b.append("IsGlobal=");
        b.append(this.isGlobal);
        b.append(", ");
        b.append("IsManaged=");
        b.append(this.isManaged);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("ExternalTypeName=");
        b.append(this.externalTypeName);
        b.append(", ");
        b.append("OptionSetType=");
        b.append((Object)this.optionSetType);
        b.append(", ");
        b.append("IntroducedVersion=");
        b.append(this.introducedVersion);
        b.append(", ");
        b.append("MetadataId=");
        b.append(this.metadataId);
        b.append(", ");
        b.append("HasChanged=");
        b.append(this.hasChanged);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private List<OptionMetadata> options;
        private String optionsNextLink;
        private String parentOptionSetName;
        private Label description;
        private Label displayName;
        private Boolean isCustomOptionSet;
        private Boolean isGlobal;
        private Boolean isManaged;
        private BooleanManagedProperty isCustomizable;
        private String name;
        private String externalTypeName;
        private OptionSetType optionSetType;
        private String introducedVersion;
        private String metadataId;
        private Boolean hasChanged;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder options(List<OptionMetadata> options) {
            this.options = options;
            this.changedFields = this.changedFields.add("Options");
            return this;
        }

        public Builder options(OptionMetadata ... options) {
            return this.options(Arrays.asList(options));
        }

        public Builder optionsNextLink(String optionsNextLink) {
            this.optionsNextLink = optionsNextLink;
            this.changedFields = this.changedFields.add("Options");
            return this;
        }

        public Builder parentOptionSetName(String parentOptionSetName) {
            this.parentOptionSetName = parentOptionSetName;
            this.changedFields = this.changedFields.add("ParentOptionSetName");
            return this;
        }

        public Builder description(Label description) {
            this.description = description;
            this.changedFields = this.changedFields.add("Description");
            return this;
        }

        public Builder displayName(Label displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder isCustomOptionSet(Boolean isCustomOptionSet) {
            this.isCustomOptionSet = isCustomOptionSet;
            this.changedFields = this.changedFields.add("IsCustomOptionSet");
            return this;
        }

        public Builder isGlobal(Boolean isGlobal) {
            this.isGlobal = isGlobal;
            this.changedFields = this.changedFields.add("IsGlobal");
            return this;
        }

        public Builder isManaged(Boolean isManaged) {
            this.isManaged = isManaged;
            this.changedFields = this.changedFields.add("IsManaged");
            return this;
        }

        public Builder isCustomizable(BooleanManagedProperty isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = this.changedFields.add("Name");
            return this;
        }

        public Builder externalTypeName(String externalTypeName) {
            this.externalTypeName = externalTypeName;
            this.changedFields = this.changedFields.add("ExternalTypeName");
            return this;
        }

        public Builder optionSetType(OptionSetType optionSetType) {
            this.optionSetType = optionSetType;
            this.changedFields = this.changedFields.add("OptionSetType");
            return this;
        }

        public Builder introducedVersion(String introducedVersion) {
            this.introducedVersion = introducedVersion;
            this.changedFields = this.changedFields.add("IntroducedVersion");
            return this;
        }

        public Builder metadataId(String metadataId) {
            this.metadataId = metadataId;
            this.changedFields = this.changedFields.add("MetadataId");
            return this;
        }

        public Builder hasChanged(Boolean hasChanged) {
            this.hasChanged = hasChanged;
            this.changedFields = this.changedFields.add("HasChanged");
            return this;
        }

        public ComplexOptionSetMetadata build() {
            ComplexOptionSetMetadata _x = new ComplexOptionSetMetadata();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ComplexOptionSetMetadata";
            _x.options = this.options;
            _x.optionsNextLink = this.optionsNextLink;
            _x.parentOptionSetName = this.parentOptionSetName;
            _x.description = this.description;
            _x.displayName = this.displayName;
            _x.isCustomOptionSet = this.isCustomOptionSet;
            _x.isGlobal = this.isGlobal;
            _x.isManaged = this.isManaged;
            _x.isCustomizable = this.isCustomizable;
            _x.name = this.name;
            _x.externalTypeName = this.externalTypeName;
            _x.optionSetType = this.optionSetType;
            _x.introducedVersion = this.introducedVersion;
            _x.metadataId = this.metadataId;
            _x.hasChanged = this.hasChanged;
            return _x;
        }
    }
}

