/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ComponentDetail;

@JsonPropertyOrder(value={"@odata.type", "RequiredComponent", "DependentComponent"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class MissingComponent
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="RequiredComponent")
    protected ComponentDetail requiredComponent;
    @JsonProperty(value="DependentComponent")
    protected ComponentDetail dependentComponent;

    protected MissingComponent() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.MissingComponent";
    }

    @Property(name="RequiredComponent")
    @JsonIgnore
    public Optional<ComponentDetail> getRequiredComponent() {
        return Optional.ofNullable(this.requiredComponent);
    }

    public MissingComponent withRequiredComponent(ComponentDetail requiredComponent) {
        MissingComponent _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MissingComponent");
        _x.requiredComponent = requiredComponent;
        return _x;
    }

    @Property(name="DependentComponent")
    @JsonIgnore
    public Optional<ComponentDetail> getDependentComponent() {
        return Optional.ofNullable(this.dependentComponent);
    }

    public MissingComponent withDependentComponent(ComponentDetail dependentComponent) {
        MissingComponent _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.MissingComponent");
        _x.dependentComponent = dependentComponent;
        return _x;
    }

    public MissingComponent withUnmappedField(String name, String value) {
        MissingComponent _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private MissingComponent _copy() {
        MissingComponent _x = new MissingComponent();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.requiredComponent = this.requiredComponent;
        _x.dependentComponent = this.dependentComponent;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("MissingComponent[");
        b.append("RequiredComponent=");
        b.append(this.requiredComponent);
        b.append(", ");
        b.append("DependentComponent=");
        b.append(this.dependentComponent);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private ComponentDetail requiredComponent;
        private ComponentDetail dependentComponent;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder requiredComponent(ComponentDetail requiredComponent) {
            this.requiredComponent = requiredComponent;
            this.changedFields = this.changedFields.add("RequiredComponent");
            return this;
        }

        public Builder dependentComponent(ComponentDetail dependentComponent) {
            this.dependentComponent = dependentComponent;
            this.changedFields = this.changedFields.add("DependentComponent");
            return this;
        }

        public MissingComponent build() {
            MissingComponent _x = new MissingComponent();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.MissingComponent";
            _x.requiredComponent = this.requiredComponent;
            _x.dependentComponent = this.dependentComponent;
            return _x;
        }
    }
}

