/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ValidationIssue;

@JsonPropertyOrder(value={"@odata.type", "ValidationSuccess", "ValidationIssueList"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class AppValidationResponse
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ValidationSuccess")
    protected Boolean validationSuccess;
    @JsonProperty(value="ValidationIssueList")
    protected List<ValidationIssue> validationIssueList;
    @JsonProperty(value="ValidationIssueList@nextLink")
    protected String validationIssueListNextLink;

    protected AppValidationResponse() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.AppValidationResponse";
    }

    @Property(name="ValidationSuccess")
    @JsonIgnore
    public Optional<Boolean> getValidationSuccess() {
        return Optional.ofNullable(this.validationSuccess);
    }

    public AppValidationResponse withValidationSuccess(Boolean validationSuccess) {
        AppValidationResponse _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.AppValidationResponse");
        _x.validationSuccess = validationSuccess;
        return _x;
    }

    @Property(name="ValidationIssueList")
    @JsonIgnore
    public CollectionPage<ValidationIssue> getValidationIssueList() {
        return new CollectionPage(this.contextPath, ValidationIssue.class, this.validationIssueList, Optional.ofNullable(this.validationIssueListNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="ValidationIssueList")
    @JsonIgnore
    public CollectionPage<ValidationIssue> getValidationIssueList(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ValidationIssue.class, this.validationIssueList, Optional.ofNullable(this.validationIssueListNextLink), Collections.emptyList(), options);
    }

    public AppValidationResponse withUnmappedField(String name, String value) {
        AppValidationResponse _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private AppValidationResponse _copy() {
        AppValidationResponse _x = new AppValidationResponse();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.validationSuccess = this.validationSuccess;
        _x.validationIssueList = this.validationIssueList;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("AppValidationResponse[");
        b.append("ValidationSuccess=");
        b.append(this.validationSuccess);
        b.append(", ");
        b.append("ValidationIssueList=");
        b.append(this.validationIssueList);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Boolean validationSuccess;
        private List<ValidationIssue> validationIssueList;
        private String validationIssueListNextLink;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder validationSuccess(Boolean validationSuccess) {
            this.validationSuccess = validationSuccess;
            this.changedFields = this.changedFields.add("ValidationSuccess");
            return this;
        }

        public Builder validationIssueList(List<ValidationIssue> validationIssueList) {
            this.validationIssueList = validationIssueList;
            this.changedFields = this.changedFields.add("ValidationIssueList");
            return this;
        }

        public Builder validationIssueList(ValidationIssue ... validationIssueList) {
            return this.validationIssueList(Arrays.asList(validationIssueList));
        }

        public Builder validationIssueListNextLink(String validationIssueListNextLink) {
            this.validationIssueListNextLink = validationIssueListNextLink;
            this.changedFields = this.changedFields.add("ValidationIssueList");
            return this;
        }

        public AppValidationResponse build() {
            AppValidationResponse _x = new AppValidationResponse();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.AppValidationResponse";
            _x.validationSuccess = this.validationSuccess;
            _x.validationIssueList = this.validationIssueList;
            _x.validationIssueListNextLink = this.validationIssueListNextLink;
            return _x;
        }
    }
}

