/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import microsoft.dynamics.crm.complex.ConditionExpression;
import microsoft.dynamics.crm.enums.LogicalOperator;

@JsonPropertyOrder(value={"@odata.type", "FilterOperator", "FilterHint", "Conditions", "Filters", "IsQuickFindFilter"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FilterExpression
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="FilterOperator")
    protected LogicalOperator filterOperator;
    @JsonProperty(value="FilterHint")
    protected String filterHint;
    @JsonProperty(value="Conditions")
    protected List<ConditionExpression> conditions;
    @JsonProperty(value="Conditions@nextLink")
    protected String conditionsNextLink;
    @JsonProperty(value="Filters")
    protected List<FilterExpression> filters;
    @JsonProperty(value="Filters@nextLink")
    protected String filtersNextLink;
    @JsonProperty(value="IsQuickFindFilter")
    protected Boolean isQuickFindFilter;

    protected FilterExpression() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FilterExpression";
    }

    @Property(name="FilterOperator")
    @JsonIgnore
    public Optional<LogicalOperator> getFilterOperator() {
        return Optional.ofNullable(this.filterOperator);
    }

    public FilterExpression withFilterOperator(LogicalOperator filterOperator) {
        FilterExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FilterExpression");
        _x.filterOperator = filterOperator;
        return _x;
    }

    @Property(name="FilterHint")
    @JsonIgnore
    public Optional<String> getFilterHint() {
        return Optional.ofNullable(this.filterHint);
    }

    public FilterExpression withFilterHint(String filterHint) {
        Checks.checkIsAscii((String)filterHint);
        FilterExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FilterExpression");
        _x.filterHint = filterHint;
        return _x;
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<ConditionExpression> getConditions() {
        return new CollectionPage(this.contextPath, ConditionExpression.class, this.conditions, Optional.ofNullable(this.conditionsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Conditions")
    @JsonIgnore
    public CollectionPage<ConditionExpression> getConditions(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, ConditionExpression.class, this.conditions, Optional.ofNullable(this.conditionsNextLink), Collections.emptyList(), options);
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<FilterExpression> getFilters() {
        return new CollectionPage(this.contextPath, FilterExpression.class, this.filters, Optional.ofNullable(this.filtersNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="Filters")
    @JsonIgnore
    public CollectionPage<FilterExpression> getFilters(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, FilterExpression.class, this.filters, Optional.ofNullable(this.filtersNextLink), Collections.emptyList(), options);
    }

    @Property(name="IsQuickFindFilter")
    @JsonIgnore
    public Optional<Boolean> getIsQuickFindFilter() {
        return Optional.ofNullable(this.isQuickFindFilter);
    }

    public FilterExpression withIsQuickFindFilter(Boolean isQuickFindFilter) {
        FilterExpression _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FilterExpression");
        _x.isQuickFindFilter = isQuickFindFilter;
        return _x;
    }

    public FilterExpression withUnmappedField(String name, String value) {
        FilterExpression _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private FilterExpression _copy() {
        FilterExpression _x = new FilterExpression();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.filterOperator = this.filterOperator;
        _x.filterHint = this.filterHint;
        _x.conditions = this.conditions;
        _x.filters = this.filters;
        _x.isQuickFindFilter = this.isQuickFindFilter;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FilterExpression[");
        b.append("FilterOperator=");
        b.append((Object)this.filterOperator);
        b.append(", ");
        b.append("FilterHint=");
        b.append(this.filterHint);
        b.append(", ");
        b.append("Conditions=");
        b.append(this.conditions);
        b.append(", ");
        b.append("Filters=");
        b.append(this.filters);
        b.append(", ");
        b.append("IsQuickFindFilter=");
        b.append(this.isQuickFindFilter);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private LogicalOperator filterOperator;
        private String filterHint;
        private List<ConditionExpression> conditions;
        private String conditionsNextLink;
        private List<FilterExpression> filters;
        private String filtersNextLink;
        private Boolean isQuickFindFilter;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder filterOperator(LogicalOperator filterOperator) {
            this.filterOperator = filterOperator;
            this.changedFields = this.changedFields.add("FilterOperator");
            return this;
        }

        public Builder filterHint(String filterHint) {
            this.filterHint = filterHint;
            this.changedFields = this.changedFields.add("FilterHint");
            return this;
        }

        public Builder conditions(List<ConditionExpression> conditions) {
            this.conditions = conditions;
            this.changedFields = this.changedFields.add("Conditions");
            return this;
        }

        public Builder conditions(ConditionExpression ... conditions) {
            return this.conditions(Arrays.asList(conditions));
        }

        public Builder conditionsNextLink(String conditionsNextLink) {
            this.conditionsNextLink = conditionsNextLink;
            this.changedFields = this.changedFields.add("Conditions");
            return this;
        }

        public Builder filters(List<FilterExpression> filters) {
            this.filters = filters;
            this.changedFields = this.changedFields.add("Filters");
            return this;
        }

        public Builder filters(FilterExpression ... filters) {
            return this.filters(Arrays.asList(filters));
        }

        public Builder filtersNextLink(String filtersNextLink) {
            this.filtersNextLink = filtersNextLink;
            this.changedFields = this.changedFields.add("Filters");
            return this;
        }

        public Builder isQuickFindFilter(Boolean isQuickFindFilter) {
            this.isQuickFindFilter = isQuickFindFilter;
            this.changedFields = this.changedFields.add("IsQuickFindFilter");
            return this;
        }

        public FilterExpression build() {
            FilterExpression _x = new FilterExpression();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.FilterExpression";
            _x.filterOperator = this.filterOperator;
            _x.filterHint = this.filterHint;
            _x.conditions = this.conditions;
            _x.conditionsNextLink = this.conditionsNextLink;
            _x.filters = this.filters;
            _x.filtersNextLink = this.filtersNextLink;
            _x.isQuickFindFilter = this.isQuickFindFilter;
            return _x;
        }
    }
}

