/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Optional;
import java.util.UUID;

@JsonPropertyOrder(value={"@odata.type", "Order", "FormId", "Name", "IsCustomizable"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class FormDisplayOrder
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Order")
    protected Integer order;
    @JsonProperty(value="FormId")
    protected UUID formId;
    @JsonProperty(value="Name")
    protected String name;
    @JsonProperty(value="IsCustomizable")
    protected Boolean isCustomizable;

    protected FormDisplayOrder() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.FormDisplayOrder";
    }

    @Property(name="Order")
    @JsonIgnore
    public Optional<Integer> getOrder() {
        return Optional.ofNullable(this.order);
    }

    public FormDisplayOrder withOrder(Integer order) {
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.order = order;
        return _x;
    }

    @Property(name="FormId")
    @JsonIgnore
    public Optional<UUID> getFormId() {
        return Optional.ofNullable(this.formId);
    }

    public FormDisplayOrder withFormId(UUID formId) {
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.formId = formId;
        return _x;
    }

    @Property(name="Name")
    @JsonIgnore
    public Optional<String> getName() {
        return Optional.ofNullable(this.name);
    }

    public FormDisplayOrder withName(String name) {
        Checks.checkIsAscii((String)name);
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.name = name;
        return _x;
    }

    @Property(name="IsCustomizable")
    @JsonIgnore
    public Optional<Boolean> getIsCustomizable() {
        return Optional.ofNullable(this.isCustomizable);
    }

    public FormDisplayOrder withIsCustomizable(Boolean isCustomizable) {
        FormDisplayOrder _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.FormDisplayOrder");
        _x.isCustomizable = isCustomizable;
        return _x;
    }

    public FormDisplayOrder withUnmappedField(String name, String value) {
        FormDisplayOrder _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private FormDisplayOrder _copy() {
        FormDisplayOrder _x = new FormDisplayOrder();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.order = this.order;
        _x.formId = this.formId;
        _x.name = this.name;
        _x.isCustomizable = this.isCustomizable;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("FormDisplayOrder[");
        b.append("Order=");
        b.append(this.order);
        b.append(", ");
        b.append("FormId=");
        b.append(this.formId);
        b.append(", ");
        b.append("Name=");
        b.append(this.name);
        b.append(", ");
        b.append("IsCustomizable=");
        b.append(this.isCustomizable);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private Integer order;
        private UUID formId;
        private String name;
        private Boolean isCustomizable;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder order(Integer order) {
            this.order = order;
            this.changedFields = this.changedFields.add("Order");
            return this;
        }

        public Builder formId(UUID formId) {
            this.formId = formId;
            this.changedFields = this.changedFields.add("FormId");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.changedFields = this.changedFields.add("Name");
            return this;
        }

        public Builder isCustomizable(Boolean isCustomizable) {
            this.isCustomizable = isCustomizable;
            this.changedFields = this.changedFields.add("IsCustomizable");
            return this;
        }

        public FormDisplayOrder build() {
            FormDisplayOrder _x = new FormDisplayOrder();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.FormDisplayOrder";
            _x.order = this.order;
            _x.formId = this.formId;
            _x.name = this.name;
            _x.isCustomizable = this.isCustomizable;
            return _x;
        }
    }
}

