/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.time.OffsetDateTime;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.enums.SubCode;
import microsoft.dynamics.crm.enums.TimeCode;

@JsonPropertyOrder(value={"@odata.type", "Start", "End", "TimeCode", "SubCode", "SourceId", "CalendarId", "SourceTypeCode", "IsActivity", "ActivityStatusCode", "Effort", "DisplayText"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class TimeInfo
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="Start")
    protected OffsetDateTime start;
    @JsonProperty(value="End")
    protected OffsetDateTime end;
    @JsonProperty(value="TimeCode")
    protected TimeCode timeCode;
    @JsonProperty(value="SubCode")
    protected SubCode subCode;
    @JsonProperty(value="SourceId")
    protected UUID sourceId;
    @JsonProperty(value="CalendarId")
    protected UUID calendarId;
    @JsonProperty(value="SourceTypeCode")
    protected Integer sourceTypeCode;
    @JsonProperty(value="IsActivity")
    protected Boolean isActivity;
    @JsonProperty(value="ActivityStatusCode")
    protected Integer activityStatusCode;
    @JsonProperty(value="Effort")
    protected Double effort;
    @JsonProperty(value="DisplayText")
    protected String displayText;

    protected TimeInfo() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.TimeInfo";
    }

    @Property(name="Start")
    @JsonIgnore
    public Optional<OffsetDateTime> getStart() {
        return Optional.ofNullable(this.start);
    }

    public TimeInfo withStart(OffsetDateTime start) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.start = start;
        return _x;
    }

    @Property(name="End")
    @JsonIgnore
    public Optional<OffsetDateTime> getEnd() {
        return Optional.ofNullable(this.end);
    }

    public TimeInfo withEnd(OffsetDateTime end) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.end = end;
        return _x;
    }

    @Property(name="TimeCode")
    @JsonIgnore
    public Optional<TimeCode> getTimeCode() {
        return Optional.ofNullable(this.timeCode);
    }

    public TimeInfo withTimeCode(TimeCode timeCode) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.timeCode = timeCode;
        return _x;
    }

    @Property(name="SubCode")
    @JsonIgnore
    public Optional<SubCode> getSubCode() {
        return Optional.ofNullable(this.subCode);
    }

    public TimeInfo withSubCode(SubCode subCode) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.subCode = subCode;
        return _x;
    }

    @Property(name="SourceId")
    @JsonIgnore
    public Optional<UUID> getSourceId() {
        return Optional.ofNullable(this.sourceId);
    }

    public TimeInfo withSourceId(UUID sourceId) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.sourceId = sourceId;
        return _x;
    }

    @Property(name="CalendarId")
    @JsonIgnore
    public Optional<UUID> getCalendarId() {
        return Optional.ofNullable(this.calendarId);
    }

    public TimeInfo withCalendarId(UUID calendarId) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.calendarId = calendarId;
        return _x;
    }

    @Property(name="SourceTypeCode")
    @JsonIgnore
    public Optional<Integer> getSourceTypeCode() {
        return Optional.ofNullable(this.sourceTypeCode);
    }

    public TimeInfo withSourceTypeCode(Integer sourceTypeCode) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.sourceTypeCode = sourceTypeCode;
        return _x;
    }

    @Property(name="IsActivity")
    @JsonIgnore
    public Optional<Boolean> getIsActivity() {
        return Optional.ofNullable(this.isActivity);
    }

    public TimeInfo withIsActivity(Boolean isActivity) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.isActivity = isActivity;
        return _x;
    }

    @Property(name="ActivityStatusCode")
    @JsonIgnore
    public Optional<Integer> getActivityStatusCode() {
        return Optional.ofNullable(this.activityStatusCode);
    }

    public TimeInfo withActivityStatusCode(Integer activityStatusCode) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.activityStatusCode = activityStatusCode;
        return _x;
    }

    @Property(name="Effort")
    @JsonIgnore
    public Optional<Double> getEffort() {
        return Optional.ofNullable(this.effort);
    }

    public TimeInfo withEffort(Double effort) {
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.effort = effort;
        return _x;
    }

    @Property(name="DisplayText")
    @JsonIgnore
    public Optional<String> getDisplayText() {
        return Optional.ofNullable(this.displayText);
    }

    public TimeInfo withDisplayText(String displayText) {
        Checks.checkIsAscii((String)displayText);
        TimeInfo _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.TimeInfo");
        _x.displayText = displayText;
        return _x;
    }

    public TimeInfo withUnmappedField(String name, String value) {
        TimeInfo _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private TimeInfo _copy() {
        TimeInfo _x = new TimeInfo();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.start = this.start;
        _x.end = this.end;
        _x.timeCode = this.timeCode;
        _x.subCode = this.subCode;
        _x.sourceId = this.sourceId;
        _x.calendarId = this.calendarId;
        _x.sourceTypeCode = this.sourceTypeCode;
        _x.isActivity = this.isActivity;
        _x.activityStatusCode = this.activityStatusCode;
        _x.effort = this.effort;
        _x.displayText = this.displayText;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("TimeInfo[");
        b.append("Start=");
        b.append(this.start);
        b.append(", ");
        b.append("End=");
        b.append(this.end);
        b.append(", ");
        b.append("TimeCode=");
        b.append((Object)this.timeCode);
        b.append(", ");
        b.append("SubCode=");
        b.append((Object)this.subCode);
        b.append(", ");
        b.append("SourceId=");
        b.append(this.sourceId);
        b.append(", ");
        b.append("CalendarId=");
        b.append(this.calendarId);
        b.append(", ");
        b.append("SourceTypeCode=");
        b.append(this.sourceTypeCode);
        b.append(", ");
        b.append("IsActivity=");
        b.append(this.isActivity);
        b.append(", ");
        b.append("ActivityStatusCode=");
        b.append(this.activityStatusCode);
        b.append(", ");
        b.append("Effort=");
        b.append(this.effort);
        b.append(", ");
        b.append("DisplayText=");
        b.append(this.displayText);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private OffsetDateTime start;
        private OffsetDateTime end;
        private TimeCode timeCode;
        private SubCode subCode;
        private UUID sourceId;
        private UUID calendarId;
        private Integer sourceTypeCode;
        private Boolean isActivity;
        private Integer activityStatusCode;
        private Double effort;
        private String displayText;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder start(OffsetDateTime start) {
            this.start = start;
            this.changedFields = this.changedFields.add("Start");
            return this;
        }

        public Builder end(OffsetDateTime end) {
            this.end = end;
            this.changedFields = this.changedFields.add("End");
            return this;
        }

        public Builder timeCode(TimeCode timeCode) {
            this.timeCode = timeCode;
            this.changedFields = this.changedFields.add("TimeCode");
            return this;
        }

        public Builder subCode(SubCode subCode) {
            this.subCode = subCode;
            this.changedFields = this.changedFields.add("SubCode");
            return this;
        }

        public Builder sourceId(UUID sourceId) {
            this.sourceId = sourceId;
            this.changedFields = this.changedFields.add("SourceId");
            return this;
        }

        public Builder calendarId(UUID calendarId) {
            this.calendarId = calendarId;
            this.changedFields = this.changedFields.add("CalendarId");
            return this;
        }

        public Builder sourceTypeCode(Integer sourceTypeCode) {
            this.sourceTypeCode = sourceTypeCode;
            this.changedFields = this.changedFields.add("SourceTypeCode");
            return this;
        }

        public Builder isActivity(Boolean isActivity) {
            this.isActivity = isActivity;
            this.changedFields = this.changedFields.add("IsActivity");
            return this;
        }

        public Builder activityStatusCode(Integer activityStatusCode) {
            this.activityStatusCode = activityStatusCode;
            this.changedFields = this.changedFields.add("ActivityStatusCode");
            return this;
        }

        public Builder effort(Double effort) {
            this.effort = effort;
            this.changedFields = this.changedFields.add("Effort");
            return this;
        }

        public Builder displayText(String displayText) {
            this.displayText = displayText;
            this.changedFields = this.changedFields.add("DisplayText");
            return this;
        }

        public TimeInfo build() {
            TimeInfo _x = new TimeInfo();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.TimeInfo";
            _x.start = this.start;
            _x.end = this.end;
            _x.timeCode = this.timeCode;
            _x.subCode = this.subCode;
            _x.sourceId = this.sourceId;
            _x.calendarId = this.calendarId;
            _x.sourceTypeCode = this.sourceTypeCode;
            _x.isActivity = this.isActivity;
            _x.activityStatusCode = this.activityStatusCode;
            _x.effort = this.effort;
            _x.displayText = this.displayText;
            return _x;
        }
    }
}

