/*
 * Decompiled with CFR 0.152.
 */
package microsoft.dynamics.crm.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.CollectionPage;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.HttpRequestOptions;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.UnmappedFields;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.Checks;
import com.github.davidmoten.odata.client.internal.UnmappedFieldsImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import microsoft.dynamics.crm.complex.Component;
import microsoft.dynamics.crm.enums.ErrorType;

@JsonPropertyOrder(value={"@odata.type", "ErrorType", "Message", "DisplayName", "ComponentId", "ComponentType", "ComponentSubType", "ParentEntityId", "ParentEntityName", "RequiredComponents", "CRMErrorCode"})
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class ValidationIssue
implements ODataType {
    @JacksonInject
    @JsonIgnore
    protected ContextPath contextPath;
    @JacksonInject
    @JsonIgnore
    protected UnmappedFieldsImpl unmappedFields;
    @JsonProperty(value="@odata.type")
    protected String odataType;
    @JsonProperty(value="ErrorType")
    protected ErrorType errorType;
    @JsonProperty(value="Message")
    protected String message;
    @JsonProperty(value="DisplayName")
    protected String displayName;
    @JsonProperty(value="ComponentId")
    protected UUID componentId;
    @JsonProperty(value="ComponentType")
    protected Integer componentType;
    @JsonProperty(value="ComponentSubType")
    protected Integer componentSubType;
    @JsonProperty(value="ParentEntityId")
    protected UUID parentEntityId;
    @JsonProperty(value="ParentEntityName")
    protected String parentEntityName;
    @JsonProperty(value="RequiredComponents")
    protected List<Component> requiredComponents;
    @JsonProperty(value="RequiredComponents@nextLink")
    protected String requiredComponentsNextLink;
    @JsonProperty(value="CRMErrorCode")
    protected Integer cRMErrorCode;

    protected ValidationIssue() {
    }

    public String odataTypeName() {
        return "Microsoft.Dynamics.CRM.ValidationIssue";
    }

    @Property(name="ErrorType")
    @JsonIgnore
    public Optional<ErrorType> getErrorType() {
        return Optional.ofNullable(this.errorType);
    }

    public ValidationIssue withErrorType(ErrorType errorType) {
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.errorType = errorType;
        return _x;
    }

    @Property(name="Message")
    @JsonIgnore
    public Optional<String> getMessage() {
        return Optional.ofNullable(this.message);
    }

    public ValidationIssue withMessage(String message) {
        Checks.checkIsAscii((String)message);
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.message = message;
        return _x;
    }

    @Property(name="DisplayName")
    @JsonIgnore
    public Optional<String> getDisplayName() {
        return Optional.ofNullable(this.displayName);
    }

    public ValidationIssue withDisplayName(String displayName) {
        Checks.checkIsAscii((String)displayName);
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.displayName = displayName;
        return _x;
    }

    @Property(name="ComponentId")
    @JsonIgnore
    public Optional<UUID> getComponentId() {
        return Optional.ofNullable(this.componentId);
    }

    public ValidationIssue withComponentId(UUID componentId) {
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.componentId = componentId;
        return _x;
    }

    @Property(name="ComponentType")
    @JsonIgnore
    public Optional<Integer> getComponentType() {
        return Optional.ofNullable(this.componentType);
    }

    public ValidationIssue withComponentType(Integer componentType) {
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.componentType = componentType;
        return _x;
    }

    @Property(name="ComponentSubType")
    @JsonIgnore
    public Optional<Integer> getComponentSubType() {
        return Optional.ofNullable(this.componentSubType);
    }

    public ValidationIssue withComponentSubType(Integer componentSubType) {
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.componentSubType = componentSubType;
        return _x;
    }

    @Property(name="ParentEntityId")
    @JsonIgnore
    public Optional<UUID> getParentEntityId() {
        return Optional.ofNullable(this.parentEntityId);
    }

    public ValidationIssue withParentEntityId(UUID parentEntityId) {
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.parentEntityId = parentEntityId;
        return _x;
    }

    @Property(name="ParentEntityName")
    @JsonIgnore
    public Optional<String> getParentEntityName() {
        return Optional.ofNullable(this.parentEntityName);
    }

    public ValidationIssue withParentEntityName(String parentEntityName) {
        Checks.checkIsAscii((String)parentEntityName);
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.parentEntityName = parentEntityName;
        return _x;
    }

    @Property(name="RequiredComponents")
    @JsonIgnore
    public CollectionPage<Component> getRequiredComponents() {
        return new CollectionPage(this.contextPath, Component.class, this.requiredComponents, Optional.ofNullable(this.requiredComponentsNextLink), Collections.emptyList(), HttpRequestOptions.EMPTY);
    }

    @Property(name="RequiredComponents")
    @JsonIgnore
    public CollectionPage<Component> getRequiredComponents(HttpRequestOptions options) {
        return new CollectionPage(this.contextPath, Component.class, this.requiredComponents, Optional.ofNullable(this.requiredComponentsNextLink), Collections.emptyList(), options);
    }

    @Property(name="CRMErrorCode")
    @JsonIgnore
    public Optional<Integer> getCRMErrorCode() {
        return Optional.ofNullable(this.cRMErrorCode);
    }

    public ValidationIssue withCRMErrorCode(Integer cRMErrorCode) {
        ValidationIssue _x = this._copy();
        _x.odataType = (String)Util.nvl((Object)this.odataType, (Object)"Microsoft.Dynamics.CRM.ValidationIssue");
        _x.cRMErrorCode = cRMErrorCode;
        return _x;
    }

    public ValidationIssue withUnmappedField(String name, String value) {
        ValidationIssue _x = this._copy();
        _x.setUnmappedField(name, value);
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (this.unmappedFields == null) {
            this.unmappedFields = new UnmappedFieldsImpl();
        }
        this.unmappedFields.put(name, value);
    }

    @JsonAnyGetter
    private UnmappedFieldsImpl unmappedFields() {
        return this.unmappedFields == null ? UnmappedFieldsImpl.EMPTY : this.unmappedFields;
    }

    public UnmappedFields getUnmappedFields() {
        return this.unmappedFields();
    }

    public void postInject(boolean addKeysToContextPath) {
    }

    public static Builder builder() {
        return new Builder();
    }

    private ValidationIssue _copy() {
        ValidationIssue _x = new ValidationIssue();
        _x.contextPath = this.contextPath;
        _x.unmappedFields = this.unmappedFields.copy();
        _x.odataType = this.odataType;
        _x.errorType = this.errorType;
        _x.message = this.message;
        _x.displayName = this.displayName;
        _x.componentId = this.componentId;
        _x.componentType = this.componentType;
        _x.componentSubType = this.componentSubType;
        _x.parentEntityId = this.parentEntityId;
        _x.parentEntityName = this.parentEntityName;
        _x.requiredComponents = this.requiredComponents;
        _x.cRMErrorCode = this.cRMErrorCode;
        return _x;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidationIssue[");
        b.append("ErrorType=");
        b.append((Object)this.errorType);
        b.append(", ");
        b.append("Message=");
        b.append(this.message);
        b.append(", ");
        b.append("DisplayName=");
        b.append(this.displayName);
        b.append(", ");
        b.append("ComponentId=");
        b.append(this.componentId);
        b.append(", ");
        b.append("ComponentType=");
        b.append(this.componentType);
        b.append(", ");
        b.append("ComponentSubType=");
        b.append(this.componentSubType);
        b.append(", ");
        b.append("ParentEntityId=");
        b.append(this.parentEntityId);
        b.append(", ");
        b.append("ParentEntityName=");
        b.append(this.parentEntityName);
        b.append(", ");
        b.append("RequiredComponents=");
        b.append(this.requiredComponents);
        b.append(", ");
        b.append("CRMErrorCode=");
        b.append(this.cRMErrorCode);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(this.unmappedFields);
        b.append(",odataType=");
        b.append(this.odataType);
        return b.toString();
    }

    public static final class Builder {
        private ErrorType errorType;
        private String message;
        private String displayName;
        private UUID componentId;
        private Integer componentType;
        private Integer componentSubType;
        private UUID parentEntityId;
        private String parentEntityName;
        private List<Component> requiredComponents;
        private String requiredComponentsNextLink;
        private Integer cRMErrorCode;
        private ChangedFields changedFields = ChangedFields.EMPTY;

        Builder() {
        }

        public Builder errorType(ErrorType errorType) {
            this.errorType = errorType;
            this.changedFields = this.changedFields.add("ErrorType");
            return this;
        }

        public Builder message(String message) {
            this.message = message;
            this.changedFields = this.changedFields.add("Message");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.changedFields = this.changedFields.add("DisplayName");
            return this;
        }

        public Builder componentId(UUID componentId) {
            this.componentId = componentId;
            this.changedFields = this.changedFields.add("ComponentId");
            return this;
        }

        public Builder componentType(Integer componentType) {
            this.componentType = componentType;
            this.changedFields = this.changedFields.add("ComponentType");
            return this;
        }

        public Builder componentSubType(Integer componentSubType) {
            this.componentSubType = componentSubType;
            this.changedFields = this.changedFields.add("ComponentSubType");
            return this;
        }

        public Builder parentEntityId(UUID parentEntityId) {
            this.parentEntityId = parentEntityId;
            this.changedFields = this.changedFields.add("ParentEntityId");
            return this;
        }

        public Builder parentEntityName(String parentEntityName) {
            this.parentEntityName = parentEntityName;
            this.changedFields = this.changedFields.add("ParentEntityName");
            return this;
        }

        public Builder requiredComponents(List<Component> requiredComponents) {
            this.requiredComponents = requiredComponents;
            this.changedFields = this.changedFields.add("RequiredComponents");
            return this;
        }

        public Builder requiredComponents(Component ... requiredComponents) {
            return this.requiredComponents(Arrays.asList(requiredComponents));
        }

        public Builder requiredComponentsNextLink(String requiredComponentsNextLink) {
            this.requiredComponentsNextLink = requiredComponentsNextLink;
            this.changedFields = this.changedFields.add("RequiredComponents");
            return this;
        }

        public Builder cRMErrorCode(Integer cRMErrorCode) {
            this.cRMErrorCode = cRMErrorCode;
            this.changedFields = this.changedFields.add("CRMErrorCode");
            return this;
        }

        public ValidationIssue build() {
            ValidationIssue _x = new ValidationIssue();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFieldsImpl();
            _x.odataType = "Microsoft.Dynamics.CRM.ValidationIssue";
            _x.errorType = this.errorType;
            _x.message = this.message;
            _x.displayName = this.displayName;
            _x.componentId = this.componentId;
            _x.componentType = this.componentType;
            _x.componentSubType = this.componentSubType;
            _x.parentEntityId = this.parentEntityId;
            _x.parentEntityName = this.parentEntityName;
            _x.requiredComponents = this.requiredComponents;
            _x.requiredComponentsNextLink = this.requiredComponentsNextLink;
            _x.cRMErrorCode = this.cRMErrorCode;
            return _x;
        }
    }
}

