package system.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum DayOfWeek implements Enum {

    @JsonProperty("Sunday")
    SUNDAY("Sunday", "0"),

    @JsonProperty("Monday")
    MONDAY("Monday", "1"),

    @JsonProperty("Tuesday")
    TUESDAY("Tuesday", "2"),

    @JsonProperty("Wednesday")
    WEDNESDAY("Wednesday", "3"),

    @JsonProperty("Thursday")
    THURSDAY("Thursday", "4"),

    @JsonProperty("Friday")
    FRIDAY("Friday", "5"),

    @JsonProperty("Saturday")
    SATURDAY("Saturday", "6");

    private final String name;
    private final String value;

    private DayOfWeek(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
