package thomsonreuters.dss.api.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Hour", 
    "Minute"})
public class HourMinute implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Hour")
    protected Integer hour;

    @JsonProperty("Minute")
    protected Integer minute;

    protected HourMinute() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.HourMinute";
    }

    @Property(name="Hour")
    @JsonIgnore
    public Optional<Integer> getHour() {
        return Optional.ofNullable(hour);
    }

    public HourMinute withHour(Integer hour) {
        HourMinute _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.HourMinute");
        _x.hour = hour;
        return _x;
    }

    @Property(name="Minute")
    @JsonIgnore
    public Optional<Integer> getMinute() {
        return Optional.ofNullable(minute);
    }

    public HourMinute withMinute(Integer minute) {
        HourMinute _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.HourMinute");
        _x.minute = minute;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private Integer hour;
        private Integer minute;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder hour(Integer hour) {
            this.hour = hour;
            this.changedFields = changedFields.add("Hour");
            return this;
        }

        public Builder minute(Integer minute) {
            this.minute = minute;
            this.changedFields = changedFields.add("Minute");
            return this;
        }

        public HourMinute build() {
            HourMinute _x = new HourMinute();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.HourMinute";
            _x.hour = hour;
            _x.minute = minute;
            return _x;
        }
    }

    private HourMinute _copy() {
        HourMinute _x = new HourMinute();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.hour = hour;
        _x.minute = minute;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HourMinute[");
        b.append("Hour=");
        b.append(this.hour);
        b.append(", ");
        b.append("Minute=");
        b.append(this.minute);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
