package thomsonreuters.dss.api.content.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.time.OffsetDateTime;
import java.util.Optional;

import thomsonreuters.dss.api.content.complex.InstrumentIdentifier;
import thomsonreuters.dss.api.content.enums.IdentifierType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "RangeStart", 
    "RangeEnd"})
public class HistoricalInstrumentIdentifier extends InstrumentIdentifier implements ODataType {


    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("RangeStart")
    protected OffsetDateTime rangeStart;

    @JsonProperty("RangeEnd")
    protected OffsetDateTime rangeEnd;

    protected HistoricalInstrumentIdentifier() {
        super();
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Content.HistoricalInstrumentIdentifier";
    }

    @Property(name="RangeStart")
    @JsonIgnore
    public Optional<OffsetDateTime> getRangeStart() {
        return Optional.ofNullable(rangeStart);
    }

    public HistoricalInstrumentIdentifier withRangeStart(OffsetDateTime rangeStart) {
        HistoricalInstrumentIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.HistoricalInstrumentIdentifier");
        _x.rangeStart = rangeStart;
        return _x;
    }

    @Property(name="RangeEnd")
    @JsonIgnore
    public Optional<OffsetDateTime> getRangeEnd() {
        return Optional.ofNullable(rangeEnd);
    }

    public HistoricalInstrumentIdentifier withRangeEnd(OffsetDateTime rangeEnd) {
        HistoricalInstrumentIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.HistoricalInstrumentIdentifier");
        _x.rangeEnd = rangeEnd;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builderHistoricalInstrumentIdentifier() {
        return new Builder();
    }

    public static final class Builder {
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private String source;
        private OffsetDateTime rangeStart;
        private OffsetDateTime rangeEnd;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public Builder source(String source) {
            this.source = source;
            this.changedFields = changedFields.add("Source");
            return this;
        }

        public Builder rangeStart(OffsetDateTime rangeStart) {
            this.rangeStart = rangeStart;
            this.changedFields = changedFields.add("RangeStart");
            return this;
        }

        public Builder rangeEnd(OffsetDateTime rangeEnd) {
            this.rangeEnd = rangeEnd;
            this.changedFields = changedFields.add("RangeEnd");
            return this;
        }

        public HistoricalInstrumentIdentifier build() {
            HistoricalInstrumentIdentifier _x = new HistoricalInstrumentIdentifier();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Content.HistoricalInstrumentIdentifier";
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            _x.source = source;
            _x.rangeStart = rangeStart;
            _x.rangeEnd = rangeEnd;
            return _x;
        }
    }

    private HistoricalInstrumentIdentifier _copy() {
        HistoricalInstrumentIdentifier _x = new HistoricalInstrumentIdentifier();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        _x.source = source;
        _x.rangeStart = rangeStart;
        _x.rangeEnd = rangeEnd;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("HistoricalInstrumentIdentifier[");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append(", ");
        b.append("Source=");
        b.append(this.source);
        b.append(", ");
        b.append("RangeStart=");
        b.append(this.rangeStart);
        b.append(", ");
        b.append("RangeEnd=");
        b.append(this.rangeEnd);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
