package thomsonreuters.dss.api.content.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Identifier", 
    "IdentifierType", 
    "UserDefinedIdentifier", 
    "UserDefinedIdentifier2", 
    "UserDefinedIdentifier3", 
    "UserDefinedIdentifier4", 
    "UserDefinedIdentifier5", 
    "UserDefinedIdentifier6"})
public class SubjectIdentifier implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("UserDefinedIdentifier")
    protected String userDefinedIdentifier;

    @JsonProperty("UserDefinedIdentifier2")
    protected String userDefinedIdentifier2;

    @JsonProperty("UserDefinedIdentifier3")
    protected String userDefinedIdentifier3;

    @JsonProperty("UserDefinedIdentifier4")
    protected String userDefinedIdentifier4;

    @JsonProperty("UserDefinedIdentifier5")
    protected String userDefinedIdentifier5;

    @JsonProperty("UserDefinedIdentifier6")
    protected String userDefinedIdentifier6;

    protected SubjectIdentifier() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Content.SubjectIdentifier";
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public SubjectIdentifier withIdentifier(String identifier) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public SubjectIdentifier withIdentifierType(IdentifierType identifierType) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="UserDefinedIdentifier")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier() {
        return Optional.ofNullable(userDefinedIdentifier);
    }

    public SubjectIdentifier withUserDefinedIdentifier(String userDefinedIdentifier) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.userDefinedIdentifier = userDefinedIdentifier;
        return _x;
    }

    @Property(name="UserDefinedIdentifier2")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier2() {
        return Optional.ofNullable(userDefinedIdentifier2);
    }

    public SubjectIdentifier withUserDefinedIdentifier2(String userDefinedIdentifier2) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        return _x;
    }

    @Property(name="UserDefinedIdentifier3")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier3() {
        return Optional.ofNullable(userDefinedIdentifier3);
    }

    public SubjectIdentifier withUserDefinedIdentifier3(String userDefinedIdentifier3) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        return _x;
    }

    @Property(name="UserDefinedIdentifier4")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier4() {
        return Optional.ofNullable(userDefinedIdentifier4);
    }

    public SubjectIdentifier withUserDefinedIdentifier4(String userDefinedIdentifier4) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        return _x;
    }

    @Property(name="UserDefinedIdentifier5")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier5() {
        return Optional.ofNullable(userDefinedIdentifier5);
    }

    public SubjectIdentifier withUserDefinedIdentifier5(String userDefinedIdentifier5) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        return _x;
    }

    @Property(name="UserDefinedIdentifier6")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier6() {
        return Optional.ofNullable(userDefinedIdentifier6);
    }

    public SubjectIdentifier withUserDefinedIdentifier6(String userDefinedIdentifier6) {
        SubjectIdentifier _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.SubjectIdentifier");
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public SubjectIdentifier build() {
            SubjectIdentifier _x = new SubjectIdentifier();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Content.SubjectIdentifier";
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            return _x;
        }
    }

    private SubjectIdentifier _copy() {
        SubjectIdentifier _x = new SubjectIdentifier();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("SubjectIdentifier[");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
