package thomsonreuters.dss.api.content.complex;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.github.davidmoten.odata.client.ContextPath;
import com.github.davidmoten.odata.client.ODataType;
import com.github.davidmoten.odata.client.Util;
import com.github.davidmoten.odata.client.annotation.Property;
import com.github.davidmoten.odata.client.internal.ChangedFields;
import com.github.davidmoten.odata.client.internal.UnmappedFields;

import java.util.Optional;

import thomsonreuters.dss.api.content.enums.IdentifierType;
import thomsonreuters.dss.api.content.enums.InstrumentType;


@JsonInclude(Include.NON_NULL)
@JsonPropertyOrder({
    "@odata.type", 
    "Key", 
    "Description", 
    "InstrumentType", 
    "Identifier", 
    "IdentifierType", 
    "UserDefinedIdentifier", 
    "UserDefinedIdentifier2", 
    "UserDefinedIdentifier3", 
    "UserDefinedIdentifier4", 
    "UserDefinedIdentifier5", 
    "UserDefinedIdentifier6"})
public class ValidatedEntity implements ODataType {

    protected ContextPath contextPath;

    @JacksonInject
    @JsonIgnore
    protected UnmappedFields unmappedFields;

    @JsonProperty("@odata.type")
    protected String odataType;

    @JsonProperty("Key")
    protected String key;

    @JsonProperty("Description")
    protected String description;

    @JsonProperty("InstrumentType")
    protected InstrumentType instrumentType;

    @JsonProperty("Identifier")
    protected String identifier;

    @JsonProperty("IdentifierType")
    protected IdentifierType identifierType;

    @JsonProperty("UserDefinedIdentifier")
    protected String userDefinedIdentifier;

    @JsonProperty("UserDefinedIdentifier2")
    protected String userDefinedIdentifier2;

    @JsonProperty("UserDefinedIdentifier3")
    protected String userDefinedIdentifier3;

    @JsonProperty("UserDefinedIdentifier4")
    protected String userDefinedIdentifier4;

    @JsonProperty("UserDefinedIdentifier5")
    protected String userDefinedIdentifier5;

    @JsonProperty("UserDefinedIdentifier6")
    protected String userDefinedIdentifier6;

    protected ValidatedEntity() {
    }

    @Override
    public String odataTypeName() {
        return "ThomsonReuters.Dss.Api.Content.ValidatedEntity";
    }

    @Property(name="Key")
    @JsonIgnore
    public Optional<String> getKey() {
        return Optional.ofNullable(key);
    }

    public ValidatedEntity withKey(String key) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.key = key;
        return _x;
    }

    @Property(name="Description")
    @JsonIgnore
    public Optional<String> getDescription() {
        return Optional.ofNullable(description);
    }

    public ValidatedEntity withDescription(String description) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.description = description;
        return _x;
    }

    @Property(name="InstrumentType")
    @JsonIgnore
    public Optional<InstrumentType> getInstrumentType() {
        return Optional.ofNullable(instrumentType);
    }

    public ValidatedEntity withInstrumentType(InstrumentType instrumentType) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.instrumentType = instrumentType;
        return _x;
    }

    @Property(name="Identifier")
    @JsonIgnore
    public Optional<String> getIdentifier() {
        return Optional.ofNullable(identifier);
    }

    public ValidatedEntity withIdentifier(String identifier) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.identifier = identifier;
        return _x;
    }

    @Property(name="IdentifierType")
    @JsonIgnore
    public Optional<IdentifierType> getIdentifierType() {
        return Optional.ofNullable(identifierType);
    }

    public ValidatedEntity withIdentifierType(IdentifierType identifierType) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.identifierType = identifierType;
        return _x;
    }

    @Property(name="UserDefinedIdentifier")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier() {
        return Optional.ofNullable(userDefinedIdentifier);
    }

    public ValidatedEntity withUserDefinedIdentifier(String userDefinedIdentifier) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.userDefinedIdentifier = userDefinedIdentifier;
        return _x;
    }

    @Property(name="UserDefinedIdentifier2")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier2() {
        return Optional.ofNullable(userDefinedIdentifier2);
    }

    public ValidatedEntity withUserDefinedIdentifier2(String userDefinedIdentifier2) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        return _x;
    }

    @Property(name="UserDefinedIdentifier3")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier3() {
        return Optional.ofNullable(userDefinedIdentifier3);
    }

    public ValidatedEntity withUserDefinedIdentifier3(String userDefinedIdentifier3) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        return _x;
    }

    @Property(name="UserDefinedIdentifier4")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier4() {
        return Optional.ofNullable(userDefinedIdentifier4);
    }

    public ValidatedEntity withUserDefinedIdentifier4(String userDefinedIdentifier4) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        return _x;
    }

    @Property(name="UserDefinedIdentifier5")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier5() {
        return Optional.ofNullable(userDefinedIdentifier5);
    }

    public ValidatedEntity withUserDefinedIdentifier5(String userDefinedIdentifier5) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        return _x;
    }

    @Property(name="UserDefinedIdentifier6")
    @JsonIgnore
    public Optional<String> getUserDefinedIdentifier6() {
        return Optional.ofNullable(userDefinedIdentifier6);
    }

    public ValidatedEntity withUserDefinedIdentifier6(String userDefinedIdentifier6) {
        ValidatedEntity _x = _copy();
        _x.odataType = Util.nvl(odataType, "ThomsonReuters.Dss.Api.Content.ValidatedEntity");
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        return _x;
    }

    @JsonAnySetter
    private void setUnmappedField(String name, Object value) {
        if (unmappedFields == null) {
            unmappedFields = new UnmappedFields();
        }
        unmappedFields.put(name, value);
    }

    @Override
    @JsonIgnore
    public UnmappedFields getUnmappedFields() {
        return unmappedFields == null ? new UnmappedFields() : unmappedFields;
    }

    @Override
    public void postInject(boolean addKeysToContextPath) {
        // do nothing;
    }

    /**
     * Returns a builder which is used to create a new
     * instance of this class (given that this class is immutable).
     *
     * @return a new Builder for this class
     */
    // Suffix used on builder factory method to differentiate the method
    // from static builder methods on superclasses
    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String key;
        private String description;
        private InstrumentType instrumentType;
        private String identifier;
        private IdentifierType identifierType;
        private String userDefinedIdentifier;
        private String userDefinedIdentifier2;
        private String userDefinedIdentifier3;
        private String userDefinedIdentifier4;
        private String userDefinedIdentifier5;
        private String userDefinedIdentifier6;
        private ChangedFields changedFields = new ChangedFields();

        Builder() {
            // prevent instantiation
        }

        public Builder key(String key) {
            this.key = key;
            this.changedFields = changedFields.add("Key");
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            this.changedFields = changedFields.add("Description");
            return this;
        }

        public Builder instrumentType(InstrumentType instrumentType) {
            this.instrumentType = instrumentType;
            this.changedFields = changedFields.add("InstrumentType");
            return this;
        }

        public Builder identifier(String identifier) {
            this.identifier = identifier;
            this.changedFields = changedFields.add("Identifier");
            return this;
        }

        public Builder identifierType(IdentifierType identifierType) {
            this.identifierType = identifierType;
            this.changedFields = changedFields.add("IdentifierType");
            return this;
        }

        public Builder userDefinedIdentifier(String userDefinedIdentifier) {
            this.userDefinedIdentifier = userDefinedIdentifier;
            this.changedFields = changedFields.add("UserDefinedIdentifier");
            return this;
        }

        public Builder userDefinedIdentifier2(String userDefinedIdentifier2) {
            this.userDefinedIdentifier2 = userDefinedIdentifier2;
            this.changedFields = changedFields.add("UserDefinedIdentifier2");
            return this;
        }

        public Builder userDefinedIdentifier3(String userDefinedIdentifier3) {
            this.userDefinedIdentifier3 = userDefinedIdentifier3;
            this.changedFields = changedFields.add("UserDefinedIdentifier3");
            return this;
        }

        public Builder userDefinedIdentifier4(String userDefinedIdentifier4) {
            this.userDefinedIdentifier4 = userDefinedIdentifier4;
            this.changedFields = changedFields.add("UserDefinedIdentifier4");
            return this;
        }

        public Builder userDefinedIdentifier5(String userDefinedIdentifier5) {
            this.userDefinedIdentifier5 = userDefinedIdentifier5;
            this.changedFields = changedFields.add("UserDefinedIdentifier5");
            return this;
        }

        public Builder userDefinedIdentifier6(String userDefinedIdentifier6) {
            this.userDefinedIdentifier6 = userDefinedIdentifier6;
            this.changedFields = changedFields.add("UserDefinedIdentifier6");
            return this;
        }

        public ValidatedEntity build() {
            ValidatedEntity _x = new ValidatedEntity();
            _x.contextPath = null;
            _x.unmappedFields = new UnmappedFields();
            _x.odataType = "ThomsonReuters.Dss.Api.Content.ValidatedEntity";
            _x.key = key;
            _x.description = description;
            _x.instrumentType = instrumentType;
            _x.identifier = identifier;
            _x.identifierType = identifierType;
            _x.userDefinedIdentifier = userDefinedIdentifier;
            _x.userDefinedIdentifier2 = userDefinedIdentifier2;
            _x.userDefinedIdentifier3 = userDefinedIdentifier3;
            _x.userDefinedIdentifier4 = userDefinedIdentifier4;
            _x.userDefinedIdentifier5 = userDefinedIdentifier5;
            _x.userDefinedIdentifier6 = userDefinedIdentifier6;
            return _x;
        }
    }

    private ValidatedEntity _copy() {
        ValidatedEntity _x = new ValidatedEntity();
        _x.contextPath = contextPath;
        _x.unmappedFields = unmappedFields;
        _x.odataType = odataType;
        _x.key = key;
        _x.description = description;
        _x.instrumentType = instrumentType;
        _x.identifier = identifier;
        _x.identifierType = identifierType;
        _x.userDefinedIdentifier = userDefinedIdentifier;
        _x.userDefinedIdentifier2 = userDefinedIdentifier2;
        _x.userDefinedIdentifier3 = userDefinedIdentifier3;
        _x.userDefinedIdentifier4 = userDefinedIdentifier4;
        _x.userDefinedIdentifier5 = userDefinedIdentifier5;
        _x.userDefinedIdentifier6 = userDefinedIdentifier6;
        return _x;
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder();
        b.append("ValidatedEntity[");
        b.append("Key=");
        b.append(this.key);
        b.append(", ");
        b.append("Description=");
        b.append(this.description);
        b.append(", ");
        b.append("InstrumentType=");
        b.append(this.instrumentType);
        b.append(", ");
        b.append("Identifier=");
        b.append(this.identifier);
        b.append(", ");
        b.append("IdentifierType=");
        b.append(this.identifierType);
        b.append(", ");
        b.append("UserDefinedIdentifier=");
        b.append(this.userDefinedIdentifier);
        b.append(", ");
        b.append("UserDefinedIdentifier2=");
        b.append(this.userDefinedIdentifier2);
        b.append(", ");
        b.append("UserDefinedIdentifier3=");
        b.append(this.userDefinedIdentifier3);
        b.append(", ");
        b.append("UserDefinedIdentifier4=");
        b.append(this.userDefinedIdentifier4);
        b.append(", ");
        b.append("UserDefinedIdentifier5=");
        b.append(this.userDefinedIdentifier5);
        b.append(", ");
        b.append("UserDefinedIdentifier6=");
        b.append(this.userDefinedIdentifier6);
        b.append("]");
        b.append(",unmappedFields=");
        b.append(unmappedFields);
        b.append(",odataType=");
        b.append(odataType);
        return b.toString();
    }

}
