package thomsonreuters.dss.api.content.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum IdentifierType implements Enum {

    @JsonProperty("NONE")
    NONE("NONE", "0"),

    @JsonProperty("ZPage")
    ZPAGE("ZPage", "1"),

    @JsonProperty("OPOL")
    OPOL("OPOL", "2"),

    @JsonProperty("ChainRIC")
    CHAIN_RIC("ChainRIC", "3"),

    @JsonProperty("OCCCode")
    OCCCODE("OCCCode", "4"),

    @JsonProperty("UnderlyingRIC")
    UNDERLYING_RIC("UnderlyingRIC", "5"),

    @JsonProperty("RICRoot")
    RICROOT("RICRoot", "6"),

    @JsonProperty("FacilityId")
    FACILITY_ID("FacilityId", "7"),

    @JsonProperty("LIN")
    LIN("LIN", "8"),

    @JsonProperty("UserDefined")
    USER_DEFINED("UserDefined", "9"),

    @JsonProperty("FileCode")
    FILE_CODE("FileCode", "10"),

    @JsonProperty("Ticker")
    TICKER("Ticker", "11"),

    @JsonProperty("LipperID")
    LIPPER_ID("LipperID", "12"),

    @JsonProperty("MIC")
    MIC("MIC", "13"),

    @JsonProperty("Sicovam")
    SICOVAM("Sicovam", "14"),

    @JsonProperty("LocalCode")
    LOCAL_CODE("LocalCode", "15"),

    @JsonProperty("ISMA")
    ISMA("ISMA", "16"),

    @JsonProperty("SICC")
    SICC("SICC", "17"),

    @JsonProperty("Sedol")
    SEDOL("Sedol", "18"),

    @JsonProperty("CommonCode")
    COMMON_CODE("CommonCode", "19"),

    @JsonProperty("BridgeSymbol")
    BRIDGE_SYMBOL("BridgeSymbol", "20"),

    @JsonProperty("Wertpapier")
    WERTPAPIER("Wertpapier", "21"),

    @JsonProperty("Valoren")
    VALOREN("Valoren", "22"),

    @JsonProperty("Isin")
    ISIN("Isin", "23"),

    @JsonProperty("Cusip")
    CUSIP("Cusip", "24"),

    @JsonProperty("Ric")
    RIC("Ric", "25"),

    @JsonProperty("RcpId")
    RCP_ID("RcpId", "26"),

    @JsonProperty("Duns")
    DUNS("Duns", "27"),

    @JsonProperty("Lei")
    LEI("Lei", "28"),

    @JsonProperty("BIC")
    BIC("BIC", "29"),

    @JsonProperty("Cik")
    CIK("Cik", "30"),

    @JsonProperty("PrimaryRegulatorId")
    PRIMARY_REGULATOR_ID("PrimaryRegulatorId", "31"),

    @JsonProperty("CompanyRegistrationNumber")
    COMPANY_REGISTRATION_NUMBER("CompanyRegistrationNumber", "32"),

    @JsonProperty("TaxFileId")
    TAX_FILE_ID("TaxFileId", "33"),

    @JsonProperty("OrgId")
    ORG_ID("OrgId", "34"),

    @JsonProperty("Cin")
    CIN("Cin", "35"),

    @JsonProperty("Sym")
    SYM("Sym", "36"),

    @JsonProperty("FundLipperId")
    FUND_LIPPER_ID("FundLipperId", "37"),

    @JsonProperty("Pid")
    PID("Pid", "38"),

    @JsonProperty("Pix")
    PIX("Pix", "39"),

    @JsonProperty("ArgentineAfipCode")
    ARGENTINE_AFIP_CODE("ArgentineAfipCode", "40"),

    @JsonProperty("PpnCusip")
    PPN_CUSIP("PpnCusip", "41");

    private final String name;
    private final String value;

    private IdentifierType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
