package thomsonreuters.dss.api.content.enums;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.github.davidmoten.odata.client.Enum;

public enum InstrumentType implements Enum {

    @JsonProperty("MortAggregate")
    MORT_AGGREGATE("MortAggregate", "0"),

    @JsonProperty("BankLoansIdentifyingFeatures")
    BANK_LOANS_IDENTIFYING_FEATURES("BankLoansIdentifyingFeatures", "1"),

    @JsonProperty("BankLoan")
    BANK_LOAN("BankLoan", "2"),

    @JsonProperty("BankQuote")
    BANK_QUOTE("BankQuote", "3"),

    @JsonProperty("BankLoanQuote")
    BANK_LOAN_QUOTE("BankLoanQuote", "4"),

    @JsonProperty("Cash")
    CASH("Cash", "5"),

    @JsonProperty("CMOQuote")
    CMOQUOTE("CMOQuote", "6"),

    @JsonProperty("CounterParty")
    COUNTER_PARTY("CounterParty", "7"),

    @JsonProperty("Derivative")
    DERIVATIVE("Derivative", "8"),

    @JsonProperty("DerivativeQuote")
    DERIVATIVE_QUOTE("DerivativeQuote", "9"),

    @JsonProperty("Entity")
    ENTITY("Entity", "10"),

    @JsonProperty("EquityParty")
    EQUITY_PARTY("EquityParty", "11"),

    @JsonProperty("EquityQuote")
    EQUITY_QUOTE("EquityQuote", "12"),

    @JsonProperty("Equity")
    EQUITY("Equity", "13"),

    @JsonProperty("FundClass")
    FUND_CLASS("FundClass", "14"),

    @JsonProperty("FundIndex")
    FUND_INDEX("FundIndex", "15"),

    @JsonProperty("Fund")
    FUND("Fund", "16"),

    @JsonProperty("GovCorpBond")
    GOV_CORP_BOND("GovCorpBond", "17"),

    @JsonProperty("GovCorpChain")
    GOV_CORP_CHAIN("GovCorpChain", "18"),

    @JsonProperty("GovCorpParty")
    GOV_CORP_PARTY("GovCorpParty", "19"),

    @JsonProperty("GovCorpQuote")
    GOV_CORP_QUOTE("GovCorpQuote", "20"),

    @JsonProperty("GovCorpUnderlying")
    GOV_CORP_UNDERLYING("GovCorpUnderlying", "21"),

    @JsonProperty("LipperBenchmark")
    LIPPER_BENCHMARK("LipperBenchmark", "22"),

    @JsonProperty("MergersAndAcquisitions")
    MERGERS_AND_ACQUISITIONS("MergersAndAcquisitions", "23"),

    @JsonProperty("MutualFundQuote")
    MUTUAL_FUND_QUOTE("MutualFundQuote", "24"),

    @JsonProperty("MortGeneric")
    MORT_GENERIC("MortGeneric", "25"),

    @JsonProperty("MoneyMarketQuote")
    MONEY_MARKET_QUOTE("MoneyMarketQuote", "26"),

    @JsonProperty("MoneyMarket")
    MONEY_MARKET("MoneyMarket", "27"),

    @JsonProperty("MortPoolQuote")
    MORT_POOL_QUOTE("MortPoolQuote", "28"),

    @JsonProperty("MortTBAs")
    MORT_TBAS("MortTBAs", "29"),

    @JsonProperty("MortgageTBAQuote")
    MORTGAGE_TBAQUOTE("MortgageTBAQuote", "30"),

    @JsonProperty("MutualFund")
    MUTUAL_FUND("MutualFund", "31"),

    @JsonProperty("MuniBond")
    MUNI_BOND("MuniBond", "32"),

    @JsonProperty("MuniChain")
    MUNI_CHAIN("MuniChain", "33"),

    @JsonProperty("MuniIssue")
    MUNI_ISSUE("MuniIssue", "34"),

    @JsonProperty("MuniParty")
    MUNI_PARTY("MuniParty", "35"),

    @JsonProperty("MuniQuote")
    MUNI_QUOTE("MuniQuote", "36"),

    @JsonProperty("Benchmark")
    BENCHMARK("Benchmark", "37"),

    @JsonProperty("PublicEquityOffering")
    PUBLIC_EQUITY_OFFERING("PublicEquityOffering", "38"),

    @JsonProperty("MortgagePool")
    MORTGAGE_POOL("MortgagePool", "39"),

    @JsonProperty("RIGsPointQuote")
    RIGS_POINT_QUOTE("RIGsPointQuote", "40"),

    @JsonProperty("RIGsCurveChain")
    RIGS_CURVE_CHAIN("RIGsCurveChain", "41"),

    @JsonProperty("CMOTranche")
    CMOTRANCHE("CMOTranche", "42"),

    @JsonProperty("Unknown")
    UNKNOWN("Unknown", "43"),

    @JsonProperty("Commodity")
    COMMODITY("Commodity", "44"),

    @JsonProperty("MifidSubclass")
    MIFID_SUBCLASS("MifidSubclass", "45"),

    @JsonProperty("OtcDerivatives")
    OTC_DERIVATIVES("OtcDerivatives", "46");

    private final String name;
    private final String value;

    private InstrumentType(String name, String value) {
        this.name = name;
        this.value = value;
    }

    @Override
    public String enumName() {
        return name;
    }

    @Override
    public String enumValue() {
        return value;
    }

}
